/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.actions.AbstractDownloadObject;
import jp.terasoluna.fw.web.struts.actions.DownloadFileNameEncoder;
import jp.terasoluna.fw.web.struts.actions.DownloadFileNameEncoderImpl;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;

public class FileDownloadUtil {
    private static final Log log = LogFactory.getLog(FileDownloadUtil.class);
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String TOO_MANY_DOWNLOAD_ERROR = "errors.too.many.download";
    protected static DownloadFileNameEncoder encoder = new DownloadFileNameEncoderImpl();

    public void setEncoder(DownloadFileNameEncoder encoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder must not be null.");
        }
        FileDownloadUtil.encoder = encoder;
    }

    public static void download(Object result, HttpServletRequest request, HttpServletResponse response) {
        block9: {
            ArrayList<AbstractDownloadObject> downloadList = new ArrayList<AbstractDownloadObject>();
            if (result instanceof AbstractDownloadObject) {
                downloadList.add((AbstractDownloadObject)result);
            } else {
                PropertyDescriptor[] propertyDescriptors;
                BeanWrapperImpl wrapper = new BeanWrapperImpl(result);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = wrapper.getPropertyDescriptors()) {
                    Class<?> type;
                    Method readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null || !AbstractDownloadObject.class.isAssignableFrom(type = readMethod.getReturnType())) continue;
                    downloadList.add((AbstractDownloadObject)wrapper.getPropertyValue(propertyDescriptor.getName()));
                }
            }
            if (downloadList.isEmpty()) {
                return;
            }
            if (downloadList.size() != 1) {
                throw new SystemException(new IllegalStateException("Too many AbstractDownloadObject properties."), TOO_MANY_DOWNLOAD_ERROR);
            }
            try {
                FileDownloadUtil.download((AbstractDownloadObject)downloadList.get(0), request, response, true);
            }
            catch (SocketException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"IOException has occurred while downloading", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(AbstractDownloadObject downloadObject, HttpServletRequest request, HttpServletResponse response, boolean forceDownload) throws IOException {
        String name;
        int contentLength;
        String contentType;
        if (downloadObject == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No download object.");
            }
            return;
        }
        Map<String, List<String>> additionalHeaders = downloadObject.getAdditionalHeaders();
        if (additionalHeaders == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Header must not be null.");
            }
            return;
        }
        Set<Map.Entry<String, List<String>>> entrySet = additionalHeaders.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String headerName = entry.getKey();
            List<String> headerValues = entry.getValue();
            if (headerValues == null || headerName == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Header name and value must not be null.");
                }
                return;
            }
            for (String headerValue : headerValues) {
                if (headerValue == null) {
                    headerValue = "";
                }
                response.addHeader(headerName, headerValue);
            }
        }
        String charSet = downloadObject.getCharset();
        if (StringUtils.isNotEmpty((String)charSet)) {
            response.setCharacterEncoding(downloadObject.getCharset());
        }
        if (StringUtils.isNotEmpty((String)(contentType = downloadObject.getContentType()))) {
            response.setContentType(downloadObject.getContentType());
        }
        if ((contentLength = downloadObject.getLengthOfData()) > 0) {
            response.setContentLength(downloadObject.getLengthOfData());
        }
        name = (name = downloadObject.getName()) != null ? encoder.encode(name, request, response) : encoder.encode("", request, response);
        FileDownloadUtil.setFileName(response, name, forceDownload);
        InputStream inputStream = downloadObject.getStream();
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            Streams.copy((InputStream)inputStream, (OutputStream)outputStream, (boolean)false);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    protected static void setFileName(HttpServletResponse response, String name, boolean forceDownload) {
        if (forceDownload) {
            String contentDispositionValue = "attachment; filename=" + name;
            response.setHeader(HEADER_CONTENT_DISPOSITION, contentDispositionValue);
        } else {
            String contentDispositionValue = "inline; filename=" + name;
            response.setHeader(HEADER_CONTENT_DISPOSITION, contentDispositionValue);
        }
    }
}

