/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Stopwatch {
    private static final Log log = LogFactory.getLog(class$com$ibatis$common$util$Stopwatch == null ? (class$com$ibatis$common$util$Stopwatch = Stopwatch.class$("com.ibatis.common.util.Stopwatch")) : class$com$ibatis$common$util$Stopwatch);
    private Map taskMap = new HashMap();
    private String currentTaskName = null;
    private long currentTaskTime = 0L;
    static /* synthetic */ Class class$com$ibatis$common$util$Stopwatch;

    public Iterator getTaskNames() {
        return this.taskMap.keySet().iterator();
    }

    public long getTaskCount(String taskName) {
        return ((TaskStat)this.taskMap.get(taskName)).getCount();
    }

    public long getTotalTaskTime(String taskName) {
        return ((TaskStat)this.taskMap.get(taskName)).getTotal();
    }

    public long getMaxTaskTime(String taskName) {
        return ((TaskStat)this.taskMap.get(taskName)).getMax();
    }

    public long getMinTaskTime(String taskName) {
        return ((TaskStat)this.taskMap.get(taskName)).getMin();
    }

    public long getAvgTaskTime(String taskName) {
        return ((TaskStat)this.taskMap.get(taskName)).getAverage();
    }

    public void start(String taskName) {
        if (log.isDebugEnabled()) {
            log.debug("Starting: " + taskName);
        }
        this.currentTaskName = taskName;
        this.currentTaskTime = System.currentTimeMillis();
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("Stopping: " + this.currentTaskName);
        }
        this.currentTaskTime = System.currentTimeMillis() - this.currentTaskTime;
        this.appendTaskTime(this.currentTaskName, this.currentTaskTime);
    }

    private synchronized void appendTaskTime(String taskName, long taskTime) {
        TaskStat stat = (TaskStat)this.taskMap.get(taskName);
        if (stat == null) {
            stat = new TaskStat();
            this.taskMap.put(taskName, stat);
        }
        stat.appendTaskTime(taskTime);
    }

    public void mergeStopwatch(Stopwatch watch) {
        Iterator names = watch.getTaskNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            long taskTime = watch.getTotalTaskTime(name);
            this.appendTaskTime(name, taskTime);
        }
    }

    public synchronized void reset() {
        this.taskMap.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Task,Count,Total,Max,Min,Avg\n");
        Iterator names = this.getTaskNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            long taskCount = this.getTaskCount(name);
            long taskTime = this.getTotalTaskTime(name);
            long taskMin = this.getMinTaskTime(name);
            long taskMax = this.getMaxTaskTime(name);
            long taskAvg = this.getAvgTaskTime(name);
            buffer.append(name + "," + taskCount + "," + taskTime + "," + taskMax + "," + taskMin + "," + taskAvg + "\n");
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaskStat {
        private static final long UNSET = -999999L;
        private long count = 0L;
        private long total = 0L;
        private long min = -999999L;
        private long max = -999999L;

        private TaskStat() {
        }

        public void appendTaskTime(long taskTime) {
            ++this.count;
            this.total += taskTime;
            if (this.max == -999999L || taskTime > this.max) {
                this.max = taskTime;
            }
            if (this.min == -999999L || taskTime < this.min) {
                this.min = taskTime;
            }
        }

        public long getTotal() {
            return this.total;
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.min;
        }

        public long getCount() {
            return this.count;
        }

        public long getAverage() {
            if (this.count > 0L) {
                return Math.round((double)this.total / (double)this.count);
            }
            return 0L;
        }
    }
}

