/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class NamespaceResolver
implements Cloneable {
    protected HashMap namespaceMap = new HashMap();
    protected HashMap reverseMap;
    protected NodePointer pointer;
    private boolean sealed;

    public void registerNamespace(String prefix, String namespaceURI) {
        this.namespaceMap.put(prefix, namespaceURI);
        this.reverseMap = null;
    }

    public void setNamespaceContextPointer(NodePointer pointer) {
        this.pointer = pointer;
    }

    public Pointer getNamespaceContextPointer() {
        return this.pointer;
    }

    public String getNamespaceURI(String prefix) {
        String uri = (String)this.namespaceMap.get(prefix);
        if (uri == null && this.pointer != null) {
            uri = this.pointer.getNamespaceURI(prefix);
        }
        return uri;
    }

    public String getPrefix(String namespaceURI) {
        if (this.reverseMap == null) {
            this.reverseMap = new HashMap();
            NodeIterator ni = this.pointer.namespaceIterator();
            if (ni != null) {
                int position = 1;
                while (ni.setPosition(position)) {
                    NodePointer nsPointer = ni.getNodePointer();
                    QName qname = nsPointer.getName();
                    this.reverseMap.put(qname.getPrefix(), qname.getName());
                    ++position;
                }
            }
            Iterator it = this.namespaceMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.reverseMap.put(entry.getValue(), entry.getKey());
            }
        }
        String prefix = (String)this.reverseMap.get(namespaceURI);
        return prefix;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void seal() {
        this.sealed = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

