/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * LbVĂR[hXgēǂݍ݂ANVB
 *
 * <p>
 * ēǂݍ݂s ReloadableCodeListLoader 
 * setCodeListLoader\bhŐݒ肷邱ƂɂāA
 * ̃ANVsƂReloadableCodeListLoader 
 * reload() \bhĂяoAR[hXg̍ēǂݍ݂sB
 * R[hXgēǂݍ݂sAStrutsݒt@C(struts-config.xml) 
 * action vpeB parameter Ɏw肵ɃtH[hB
 * tH[h悪ݒ肳ĂȂꍇA
 * SC_NOT_FOUNDi404j G[ԂB
 * </p>
 *
 * <strong>Bean`t@C̐ݒB</strong><br>
 * ȉ ReloadableCodeListLoader Ƃ &quot;loader1&quot; 
 * `Ăꍇ̗łB
 * <code><pre>
 * &lt;bean name=<Strong>"/reloadAction"</Strong> scope="prototype"
 *       class = "jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction"&gt;
 *   <Strong>&lt;property name="codeListLoader"&gt;
 *     &lt;ref bean="loader1"/&gt;
 *   &lt;/property&gt;</Strong>
 * &lt;/bean&gt;
 * </pre></code>
 * <strong> Strutsݒt@C(struts-config.xml) ݒ</strong><br>
 * <code><pre>
 *  &lt;action path=<Strong>"/reloadAction"</Strong>
 *          name="_sampleFormBean"
 *          parameter = "/reloaded.do"/&gt;
 * </pre></code></p>
 * <p>
 *
 * ReloadableCodeListLoader ̂̂Đ@\ł͂Ȃ߁A
 * ̒g SQL ȂǂύX邱Ƃ͕s\łB<br>
 *
 * ēǂݍ݉\ȃR[hXg̐ɂẮA
 * ReloadableCodeListLoader QƁB<br>
 * ܂JSP̃R[hXg̎gp@ɂẮADefineCodeListTagA
 * DefineCodeListCountTag QƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 *
 */
public class ReloadCodeListAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ReloadCodeListAction.class);

    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR =
        "error.forward.errorpage";

    /**
     * ēǂݍ݂{邽߂Ɏgp ReloadableCodeListLoaderB
     */
    private ReloadableCodeListLoader codeListLoader = null;

    /**
     * LbVĂR[hXgēǍ݂B
     *
     * <p>
     *  ̏sA parameter Ɏw肵ɃtH[hB
     *  parameter w肳ĂȂAcodeListLoader݂Ȃꍇ
     * SC_NOT_FOUNDi404j G[ԂB
     * </p>
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @return parameter Ɏw肵Jڐ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                        ActionForm form,
                                        HttpServletRequest req,
                                        HttpServletResponse res) {

        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }

        if (codeListLoader != null) {
            codeListLoader.reload();
        }

        String path = mapping.getParameter();

        if (path == null) {
            // p[^ݒ肳ĂȂꍇAi404jG[ԋpB
            try {
                res.sendError(HttpServletResponse.SC_NOT_FOUND);
            } catch (IOException e) {
                log.error("Error page(404) forwarding failed.");
                throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
            }
            return null;
        }

        return new ActionForward(path);
    }

    /**
     * codeListLoader 擾B
     *
     * @return codeListLoader \tB[hlB
     */
    public ReloadableCodeListLoader getCodeListLoader() {
        return codeListLoader;
    }

    /**
     * codeListLoader ݒ肷B
     *
     * @param codeListLoader codeListLoader \tB[hlB
     */
    public void setCodeListLoader(ReloadableCodeListLoader codeListLoader) {
        this.codeListLoader = codeListLoader;
    }
}
