/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.init;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorException;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobControlTableHandler;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobRequestInfoCollector
extends AbstractCollector {
    private static Log log = LogFactory.getLog(JobRequestInfoCollector.class);
    protected JobControlTableHandler jobControlTableHandler = null;
    private long intervalSeconds = 0L;
    private int refreshCount = 0;
    protected String jobBeanPath = null;

    protected CollectorResult doCollect(JobContext jobContext, CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        int collected = 0;
        int selectCount = 0;
        JobInfo jobControlInfo = null;
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        while (true) {
            if ((jobControlInfo = this.getJobMessageInfo(selectCount, jobControlInfo)) == null) {
                try {
                    Thread.sleep(this.intervalSeconds * 1000L);
                    selectCount = 0;
                }
                catch (InterruptedException e) {
                    throw new CollectorException(e, null);
                }
            }
            transactionalJobStatus.beginTransaction();
            int count = this.updateJobStart(jobControlInfo);
            if (count == 1) {
                collectedDataHandler.handle(jobControlInfo, collected++);
                transactionalJobStatus.commit();
            } else {
                transactionalJobStatus.rollback();
            }
            if (this.jobBeanPath != null) {
                this.overrideDescriptionPath(jobControlInfo);
            }
            if ("STOP".equals(jobControlInfo.getJobId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"stopped batch daemon ");
                }
                collectedDataHandler.close();
                return new CollectorResult(ReturnCode.NORMAL_END, collected);
            }
            if (selectCount >= this.refreshCount) {
                selectCount = 0;
                continue;
            }
            ++selectCount;
        }
    }

    protected int updateJobStart(JobInfo jobInfo) {
        return this.jobControlTableHandler.updateJobStart(jobInfo);
    }

    protected JobInfo getJobMessageInfo(int selectCount, JobInfo jobInfo) {
        if (selectCount == 0) {
            return this.jobControlTableHandler.getJobRequestData();
        }
        return this.jobControlTableHandler.getJobRequestData(jobInfo);
    }

    protected void overrideDescriptionPath(JobInfo jobInfo) {
    }

    public void setJobControlTableHandler(JobControlTableHandler jobControlTableHandler) {
        this.jobControlTableHandler = jobControlTableHandler;
    }

    public void setIntervalSeconds(long intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public void setRefreshCount(int refreshCount) {
        this.refreshCount = refreshCount;
    }

    public void setJobBeanPath(String jobBeanPath) {
        throw new UnsupportedOperationException();
    }
}

