/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.LinkedHashMap;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnableQueueProcessor
implements Runnable {
    private QueueProcessor queueProcessor;
    private WorkQueue workQueue;
    private JobStatus jobStatus;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap;
    private JobExceptionHandler defaultJobExceptionHandler;

    public RunnableQueueProcessor(QueueProcessor queueProcessor, WorkQueue workQueue, JobStatus jobStatus, LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap, JobExceptionHandler defaultJobExceptionHandler) {
        this.queueProcessor = queueProcessor;
        this.workQueue = workQueue;
        this.jobStatus = jobStatus;
        this.exceptionHandlerMap = exceptionHandlerMap;
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    @Override
    public void run() {
        try {
            this.queueProcessor.process(this.workQueue, this.jobStatus);
        }
        catch (Exception e) {
            JobException jobException = new JobException(e);
            JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(jobException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
            handler.handlException(null, jobException, this.jobStatus);
        }
    }
}

