/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.ArrayList;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFileLineIterator<T>
extends AbstractFileLineIterator<T> {
    private char delimiter = (char)44;
    private char encloseChar = '\u0000';

    public VariableFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> textSetterMap) {
        super(fileName, clazz, textSetterMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() == '\u0000') {
            throw new FileException("Delimiter can not use '\\u0000'.", new IllegalStateException(), fileName);
        }
        this.setEncloseChar(fileFormat.encloseChar());
        this.setDelimiter(fileFormat.delimiter());
    }

    @Override
    protected String[] separateColumns(String fileLineString) {
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }
        char delimiterCharacter = this.delimiter;
        StringBuilder columnBuilder = new StringBuilder();
        StringBuilder beforeChararacter = new StringBuilder(1);
        StringBuilder columnIni = new StringBuilder(1);
        ArrayList<String> columnList = new ArrayList<String>(1);
        boolean isEnclosed = true;
        boolean isEscaped = false;
        if (this.encloseChar == '\u0000') {
            return fileLineString.split(Character.toString(delimiterCharacter));
        }
        for (char currentChar : fileLineString.toCharArray()) {
            if (columnIni.length() == 0) {
                columnIni.append(currentChar);
            }
            if (columnIni.charAt(0) == this.encloseChar) {
                if (isEnclosed) {
                    if (currentChar == this.encloseChar) {
                        isEnclosed = false;
                    }
                } else if (currentChar == this.encloseChar && !isEscaped) {
                    isEscaped = true;
                } else if (currentChar == this.encloseChar && isEscaped) {
                    columnBuilder.append(currentChar);
                    isEscaped = false;
                } else if (currentChar == delimiterCharacter) {
                    if (isEscaped) {
                        columnList.add(columnBuilder.toString());
                        columnIni.delete(0, columnIni.length());
                        columnBuilder.delete(0, columnBuilder.length());
                        isEnclosed = true;
                        isEscaped = false;
                    } else {
                        columnBuilder.append(currentChar);
                        isEscaped = false;
                    }
                } else {
                    columnBuilder.append(currentChar);
                }
            } else if (currentChar != delimiterCharacter) {
                columnBuilder.append(currentChar);
            } else {
                columnList.add(columnBuilder.toString());
                columnIni.delete(0, columnIni.length());
                columnBuilder.delete(0, columnBuilder.length());
            }
            beforeChararacter.delete(0, beforeChararacter.length());
            beforeChararacter.append(currentChar);
        }
        columnList.add(columnBuilder.toString());
        return columnList.toArray(new String[columnList.size()]);
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }

    public void setEncloseChar(char encloseChar) {
        this.encloseChar = encloseChar;
    }
}

