/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.standard;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.RunnableQueueProcessor;
import jp.terasoluna.fw.batch.standard.WorkerExecutorService;

import org.springframework.beans.factory.DisposableBean;

/**
 * <code>WorkerExecutorService</code> C^tF[X̕WNXB
 * 
 * <p><code>Executors.newFixedThreadPool()</code> ō쐬Xbhv[ŁA
 * [JsB</p>
 * 
 */
public class FixedThreadPoolWorkerExecutorService
        implements WorkerExecutorService, DisposableBean {

    /**
     * sT[rXB
     */
    private ExecutorService executorService = null;

    /**
     * Onhi[MapB
     */
    private LinkedHashMap<JobException, JobExceptionHandler> 
        exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * RXgN^B
     * 
     * @param threads Xbh
     */
    public FixedThreadPoolWorkerExecutorService(int threads) {
        if (threads <= 0) {
                    StringBuilder builder = 
                        new StringBuilder("Threads is illegal. ");
                    builder.append(threads);
                throw new InitializeException(builder.toString());
           }
        executorService = Executors.newFixedThreadPool(threads);
    }

    /**
     * [J[so^B
     *
     * @param queueProcessor L[vZbT
     * @param workQueue L[
     * @param jobStatus WuXe[^X
     * @return [J̏ʂɔ񓯊ŃANZX߂̃t[`[
     */
    public Future< ? > submit(QueueProcessor queueProcessor,
            WorkQueue workQueue, JobStatus jobStatus) {
        return executorService.submit(new RunnableQueueProcessor(
                queueProcessor, workQueue, jobStatus, exceptionHandlerMap,
                defaultJobExceptionHandler));
    }

    /**
     * CX^XjۂɁASpring fremeworkĂ΂R[
     * obN\bhB
     * 
     * <p>sT[rXVbg_EB</p>
     */
    public void destroy() {
        executorService.shutdown();
    }
    /**
     * Onhi[Mapݒ肷B
     *
     * @param exceptionHandlerMap Onhi[Map
     */
    public void setExceptionHandlerMap(
         LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * ftHgOnhݒ肷B
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
        JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }
}
