/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;


import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * gUNVs <code>SupportProcessor</code> C^tF[X̎
 * NXB
 * 
 * <p><code>supportProcessor</code> ɐݒ肳ꂽT|[gvZbT̏
 * gUNVōsB<code>supportProcessor</code> ̃T|[gvZb
 * TNOɃgUNVJnAT|[gvZbTÑWuXe[^
 * XɂăgUNṼR~bg^[obNsB</p>
 * 
 * <p><code>supportProcessor</code> ̃T|[gvZbTÑWuXe[
 * ^XA<code>JobStatus.STATE.STARTED</code>A<code>JobStatus.STATE.RESTARTED
 * </code>A<code>JobStatus.STATE.ENDING_NORMALLY</code>
 * łꍇɂ̓R~bgÂق̏ꍇɂ̓[obNB</p>
 * 
 * <p>gUNVs߁AWuXe[^XƂ 
 * <code>TransactionalJobStatus</code>gpKvB</p>
 * 
 */
public class TransactionalSupportProcessor implements SupportProcessor {

    /**
     * T|[gvZbTB
     */
    private SupportProcessor supportProcessor = null;
    
    /**
     * T|[gsB
     *
     * @param jobContext WuReLXg
     * @param jobStatus gUNViWuXe[^X
     */
    public void process(JobContext jobContext, JobStatus jobStatus) {
        if (supportProcessor.canSkip()) {
            return;
        }

        // T|[gpgUNVJn
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        transactionalJobStatus.beginTransaction();

        // Z[u|CgLɍŏ̃Z[u|Cg쐬
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.releaseAndCreateSavepoint();
        }

        supportProcessor.process(jobContext, jobStatus);
        
        if (jobStatus.isExecuting() 
                || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY
                || jobStatus.isShutdownGraceful()) {
            transactionalJobStatus.commit();
        } else {
            transactionalJobStatus.rollback();
            // Z[u|CgL͍ŌɃR~bg
            if (transactionalJobStatus.useSavepoint()) {
                transactionalJobStatus.commit();
            }
        }
    }

    /**
     * T|[gvZbTݒ肷B
     * 
     * @param supportProcessor T|[gvZbT
     */
    public void setSupportProcessor(SupportProcessor supportProcessor) {
        this.supportProcessor = supportProcessor;
    }

    /**
     * WuOXLbvłꍇɂ́A<code>true</code> ԂB 
     * 
     * @return WuOXLbvłꍇɂ́A<code>true</code>
     */
    public boolean canSkip() {
        return supportProcessor.canSkip();
    }
}
