/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.validation;

import jp.terasoluna.fw.batch.messages.MessageAccessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

/**
 * <code>ValidationResultHandler</code> C^tF[X̕WNXB
 * ̓`FbNʂ珈fAp̔sB<BR>
 *
 */
public class StandardValidationResultHandler 
    implements ValidationResultHandler {

    /**
     * OCX^XB
     */
    private static Log log = 
        LogFactory.getLog(StandardValidationResultHandler.class);

    /**
     * G[ptOB
     */
    private boolean errorContinueFlg = false;
    
    /**
     * bZ[W擾NX̃CX^XB
     */
    private MessageAccessor messageAccessor = null;
    
    /**
     * ̓`FbNʂ珈fAp̔sB
     * <code>errorContinueFlg<code><code>true<code>̏ꍇ
     * ̓`FbNʂG[̏ꍇA<code>false<code>ԂB
     * <code>errorContinueFlg<code><code>false<code>̏ꍇ
     * ̓`FbNʂG[̏ꍇAO𔭐𒆒fB
     *
     * @param bindException L[vZbT
     * @param value L[
     * @return 茋ʁAG[̏ꍇ<code>false<code>
     */
    public boolean handle(BindException bindException, Object value) {
        if (bindException.getErrorCount() > 0) {
            if (errorContinueFlg) {
                   StringBuilder errorString = new StringBuilder();
                   for (Object objectErrors : bindException.getAllErrors()) {
                       FieldError fieldError = (FieldError) objectErrors;
                    errorString.append(
                            messageAccessor.getMessage(
                                    fieldError.getDefaultMessage(), 
                                    fieldError.getArguments()));
                       
                   }
                log.warn(errorString.toString());
                return false;
            } else {
                throw new ValidateException(bindException);
            }
        }
        return true;
    }

    /**
     * G[ptOݒ肷B
     * 
     * @param errorContinueFlg G[ptO
     */
    public void setErrorContinueFlg(boolean errorContinueFlg) {
        this.errorContinueFlg = errorContinueFlg;
    }

    /**
     * bZ[W擾NX̃CX^Xݒ肷B
     * 
     * @param messageAccessor bZ[W擾NX̃CX^X
     */
    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }
}
