/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartQueueProcessor
extends QueueProcessor {
    private Workable<WorkUnit> normalWorker = null;
    private Workable<WorkUnit> restartWorker = null;

    @Override
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        this.printStartLog("RestartQueueProcessor processing START", jobStatus);
        WorkUnit prev = null;
        while (true) {
            WorkUnit element;
            if ((element = workQueue.take()).isEndMark()) {
                if (prev == null) break;
                this.restartWorker.work(prev, jobStatus);
                break;
            }
            if (prev != null) {
                this.normalWorker.work(prev, jobStatus);
            }
            if (!jobStatus.isContinue()) break;
            prev = element;
        }
        this.printEndLog("RestartQueueProcessor processing END", jobStatus);
    }

    @Override
    public void setWorker(Workable<WorkUnit> worker) {
        this.normalWorker = worker;
    }

    public void setRestartWorker(Workable<WorkUnit> restartWorker) {
        this.restartWorker = restartWorker;
    }
}

