/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;

public class Chunker
implements CollectedDataHandler {
    private WorkQueue queue;
    private int chunkSize;
    private Chunk currentChunk;
    private JobContext jobContext;

    public Chunker(WorkQueue queue, int chunkSize, JobContext jobContext) {
        this.queue = queue;
        this.chunkSize = chunkSize;
        this.jobContext = jobContext;
        this.currentChunk = new Chunk(chunkSize, jobContext);
    }

    public void handle(Object row, int index) {
        this.currentChunk.add(row);
        if (this.currentChunk.size() >= this.chunkSize) {
            this.queue.put(this.currentChunk);
            this.currentChunk = new Chunk(this.chunkSize, this.jobContext);
        }
    }

    public void close() {
        if (this.currentChunk.size() > 0) {
            this.queue.put(this.currentChunk);
        }
        this.queue.close();
    }
}

