/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobStatusSummarizer;

public class StandardJobStatusSummarizer
implements JobStatusSummarizer {
    public void summarize(JobStatus jobStatus) {
        if (jobStatus.getChildJobStatusList() == null || jobStatus.getChildJobStatusList().isEmpty()) {
            return;
        }
        for (JobStatus childJobStatus : jobStatus.getChildJobStatusList()) {
            this.summarize(childJobStatus);
            if (jobStatus.getJobState().ordinal() >= childJobStatus.getJobState().ordinal() || jobStatus.getJobState() == JobStatus.STATE.STARTED && childJobStatus.getJobState() == JobStatus.STATE.RESTARTED) continue;
            jobStatus.setJobState(childJobStatus.getJobState());
            jobStatus.setJobExitCode(childJobStatus.getJobExitCode());
        }
        this.summarizeExitCode(jobStatus);
    }

    private void summarizeExitCode(JobStatus jobStatus) {
        if (jobStatus.getJobExitCode() != null) {
            return;
        }
        Integer exitCode = null;
        for (JobStatus childJobStatus : jobStatus.getChildJobStatusList()) {
            this.summarizeExitCode(childJobStatus);
            if (childJobStatus.getJobExitCode() == null || jobStatus.getJobState() != childJobStatus.getJobState()) continue;
            if (exitCode == null) {
                exitCode = childJobStatus.getJobExitCode();
                continue;
            }
            if (exitCode >= childJobStatus.getJobExitCode()) continue;
            exitCode = childJobStatus.getJobExitCode();
        }
        jobStatus.setJobExitCode(exitCode);
    }
}

