/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportLogicException;
import jp.terasoluna.fw.batch.core.SupportLogicResultHandler;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardSupportProcessor
implements SupportProcessor {
    private static Log log = LogFactory.getLog(StandardSupportProcessor.class);
    private List<SupportLogic<JobContext>> supportLogicList = null;
    private SupportLogicResultHandler supportLogicResultHandler = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();
    private String supportProcessorName = null;

    @Override
    public void process(JobContext jobContext, JobStatus jobStatus) {
        if (this.canSkip()) {
            return;
        }
        if (!jobStatus.isContinue()) {
            return;
        }
        BLogicResult supportLogicResult = null;
        try {
            for (SupportLogic<JobContext> supportLogic : this.supportLogicList) {
                if (jobStatus.isShutdownImmediate()) {
                    jobStatus.suspend();
                    return;
                }
                try {
                    supportLogicResult = supportLogic.execute(jobContext);
                    this.supportLogicResultHandler.handle(supportLogicResult, jobStatus, this.supportProcessorName);
                }
                catch (RuntimeException e) {
                    SupportLogicException wrappingException = this.createSupportLogicException(supportLogicResult, e);
                    JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
                    try {
                        handler.handlException(jobContext, wrappingException, jobStatus);
                    }
                    catch (RuntimeException handlerException) {
                        log.error((Object)("[Exception in ExceptionHandler] Error JobID: " + jobStatus.getJobId()), (Throwable)handlerException);
                        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                    }
                }
                if (jobStatus.isContinue()) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }

    private SupportLogicException createSupportLogicException(BLogicResult supportLogicResult, RuntimeException e) {
        SupportLogicException wrappingException = new SupportLogicException(e, supportLogicResult, this.supportProcessorName);
        return wrappingException;
    }

    @Override
    public boolean canSkip() {
        return this.supportLogicList == null || this.supportLogicList.size() == 0;
    }

    public void setSupportLogicList(List<SupportLogic<JobContext>> supportLogicList) {
        this.supportLogicList = supportLogicList;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setSupportLogicResultHandler(SupportLogicResultHandler supportLogicResultHandler) {
        this.supportLogicResultHandler = supportLogicResultHandler;
    }

    public void setSupportProcessorName(String supportProcessorName) {
        this.supportProcessorName = supportProcessorName;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

