/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFileLineIterator<T>
extends AbstractFileLineIterator<T> {
    private static final char DELIMITER = ',';
    private static final char ENCLOSE_CHAR = '\u0000';

    public FixedFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> textSetterMap) {
        super(fileName, clazz, textSetterMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() != ',') {
            throw new FileException("Delimiter can not change.", new IllegalStateException(), fileName);
        }
        if (fileFormat.encloseChar() != '\u0000') {
            throw new FileException("EncloseChar can not change.", new IllegalStateException(), fileName);
        }
    }

    @Override
    protected String[] separateColumns(String fileLineString) {
        int columnBytesTotal = 0;
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }
        Field[] fieldList = new Field[this.getFields().length];
        ArrayList<String> columnList = new ArrayList<String>();
        for (Field field : this.getFields()) {
            InputFileColumn inputFileColumn;
            if (field == null || (inputFileColumn = field.getAnnotation(InputFileColumn.class)) == null) continue;
            if (fieldList[inputFileColumn.columnIndex()] == null) {
                fieldList[inputFileColumn.columnIndex()] = field;
                continue;
            }
            throw new FileException("Column index is repeated.", this.getFileName());
        }
        StringBuilder columnBuilder = new StringBuilder();
        int fileLineStringIndex = 0;
        for (Field field : fieldList) {
            int columnBytes = 0;
            columnBuilder.delete(0, columnBuilder.length());
            if (field == null) continue;
            InputFileColumn inputFileColumn = field.getAnnotation(InputFileColumn.class);
            while (columnBytes < inputFileColumn.bytes()) {
                if (fileLineString.length() <= fileLineStringIndex) {
                    throw new FileException("Data size is different from a set point of a column.", this.getFileName());
                }
                String columnChar = fileLineString.substring(fileLineStringIndex, fileLineStringIndex + 1);
                try {
                    if (columnChar.getBytes(this.getFileEncoding()).length + columnBytes <= inputFileColumn.bytes()) {
                        columnBuilder.append(columnChar);
                        columnBytes += columnChar.getBytes(this.getFileEncoding()).length;
                        ++fileLineStringIndex;
                        continue;
                    }
                    throw new FileException("Data size is different from a set point of a column.", this.getFileName());
                }
                catch (UnsupportedEncodingException e) {
                    throw new FileException(e, this.getFileName());
                }
            }
            columnBytesTotal += inputFileColumn.bytes();
            columnList.add(columnBuilder.toString());
        }
        try {
            if (columnBytesTotal != fileLineString.getBytes(this.getFileEncoding()).length) {
                throw new FileException("Total Columns byte is different from Total FileLineObject's columns byte.", new IllegalStateException(), this.getFileName());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(e, this.getFileName());
        }
        return columnList.toArray(new String[columnList.size()]);
    }

    @Override
    public char getDelimiter() {
        return ',';
    }

    @Override
    public char getEncloseChar() {
        return '\u0000';
    }
}

