/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.sql.simple;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.util.StringTokenizer;

public class SimpleDynamicSql
implements Sql {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String ELEMENT_TOKEN = "$";
    private String sqlStatement;
    private SqlMapExecutorDelegate delegate;

    public SimpleDynamicSql(SqlMapExecutorDelegate delegate, String sqlStatement) {
        this.delegate = delegate;
        this.sqlStatement = sqlStatement;
    }

    public String getSql(RequestScope request, Object parameterObject) {
        return this.processDynamicElements(this.sqlStatement, parameterObject);
    }

    public ParameterMap getParameterMap(RequestScope request, Object parameterObject) {
        return request.getParameterMap();
    }

    public ResultMap getResultMap(RequestScope request, Object parameterObject) {
        return request.getResultMap();
    }

    public void cleanup(RequestScope request) {
    }

    public static boolean isSimpleDynamicSql(String sql) {
        return sql != null && sql.indexOf(ELEMENT_TOKEN) > -1;
    }

    private String processDynamicElements(String sql, Object parameterObject) {
        StringTokenizer parser = new StringTokenizer(sql, ELEMENT_TOKEN, true);
        StringBuffer newSql = new StringBuffer();
        String token = null;
        String lastToken = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken();
            if (ELEMENT_TOKEN.equals(lastToken)) {
                if (ELEMENT_TOKEN.equals(token)) {
                    newSql.append(ELEMENT_TOKEN);
                    token = null;
                } else {
                    Object value = null;
                    if (parameterObject != null) {
                        value = this.delegate.getTypeHandlerFactory().hasTypeHandler(parameterObject.getClass()) ? parameterObject : PROBE.getObject(parameterObject, token);
                    }
                    if (value != null) {
                        newSql.append(String.valueOf(value));
                    }
                    if (!ELEMENT_TOKEN.equals(token = parser.nextToken())) {
                        throw new SqlMapException("Unterminated dynamic element in sql (" + sql + ").");
                    }
                    token = null;
                }
            } else if (!ELEMENT_TOKEN.equals(token)) {
                newSql.append(token);
            }
            lastToken = token;
        }
        return newSql.toString();
    }
}

