/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.batch.core.BLogicException;
import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Rg[uCNsNXB
 * 
 */
public class ControlBreakProcessor {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(ControlBreakProcessor.class);

    /**
     * Rg[uCNݒB
     */
    private ControlBreakDef controlBreakDef = null;

    /**
     * rWlXWbNʏnhB
     */
    private BLogicResultHandler blogicResultHandler = null;
    
    /**
     * Onhi[MapB
     */
    private Map<JobException, JobExceptionHandler> exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * `N͈͂ƃRg[uCN͈͂
     * Rg[uCNɂ Rg[uCNsB
     * 
     * @param controlBreakChunk Rg[uCNp`N
     * @param jobStatus WuXe[^X
     * @param batchUpdateMapList ob`XVXg
     */
    public void doChunkControlBreak(
            ControlBreakChunk controlBreakChunk,
            JobStatus jobStatus, 
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        ControlBreakDefItem chunkControlBreakDefItem = controlBreakDef
                .getChunkControlBreakDefItem();

        if (chunkControlBreakDefItem.getBreakKey().size() == 0) {
            return;
        }

        Map<String, Object> chunkControlBreakKeyMap = 
            controlBreakChunk.getChunkControlBreakMap();
        ControlBreakHandler<JobContext> controlBreakHandler = 
            chunkControlBreakDefItem.getControlBreakHandler();

        // Rg[uCNN
        processControlBreak(controlBreakChunk.getJobContext(), jobStatus,
                batchUpdateMapList, chunkControlBreakKeyMap,
                controlBreakHandler);
    }

    /**
     * `N͈͂Rg[uCN͈͂L
     * Rg[uCNɂ Rg[uCNsB
     * 
     * @param controlBreakChunk Rg[uCNp`N
     * @param jobStatus WuXe[^X
     * @param batchUpdateMapList ob`XVXg
     */
    public void doTransChunkControlBreak(ControlBreakChunk controlBreakChunk,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {

        List<List<String>> transChunkControlBreakKeyList = controlBreakChunk
                .getTransChunkControlBreakKeyList();

        Map<String, Object> chunkControlBreakKeyMap = controlBreakChunk
                .getChunkControlBreakMap();

        Map<String, Object> transChunkControlBreakKeyMap = 
            new HashMap<String, Object>();
        for (List<String> transChunkControlBreakKey
                : transChunkControlBreakKeyList) {
            transChunkControlBreakKeyMap.clear();
            if (transChunkControlBreakKey.size() == 0) {
                continue;
            }
            if (!jobStatus.isContinue()) {
                // Rg[uCNnhɂďIԂɂȂꍇɂ́A
                // 㑱̃Rg[uCNsȂ
                return;
            }

            ControlBreakHandler<JobContext> controlBreakHandler = 
                controlBreakDef
                   .getTransChunkControlBreakHandler(transChunkControlBreakKey);
            for (String propertyName : transChunkControlBreakKey) {
                Object value = chunkControlBreakKeyMap.get(propertyName);
                transChunkControlBreakKeyMap.put(propertyName, value);
            }
            // Rg[uCNN
            processControlBreak(controlBreakChunk.getJobContext(), jobStatus,
                    batchUpdateMapList, transChunkControlBreakKeyMap,
                    controlBreakHandler);

        }
    }

    /**
     * SgX`NRg[uCNNB
     * ŏI`N̂̏ꍇ͑SgX`NRg[uCNsB
     * 
     * @param controlBreakChunk Rg[uCNp`N
     * @param jobStatus WuXe[^X
     * @param batchUpdateMapList ob`XVXg
     */
    public void doAllTransChunkControlBreak(
            ControlBreakChunk controlBreakChunk, JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        // `NRg[uCNʂтȂ
        Map<String, Object> allChunkControlBreakKeyMap = controlBreakChunk
                .getChunkControlBreakMap();

        // `NRg[uCNʂтȂ
        List<ControlBreakDefItem> transChunkControlBreakDefItemList = 
            controlBreakDef.getTransChunkControlBreakDefItemList();

        HashMap<String, Object> breakKeyValueMap =
            new HashMap<String, Object>();
        for (ControlBreakDefItem transChunkControlBreakDefItem
                : transChunkControlBreakDefItemList) {
            breakKeyValueMap.clear();
            if (transChunkControlBreakDefItem.getBreakKey().size() == 0) {
                continue;
            }

            // WuXe[^X`FbN
            if (!jobStatus.isContinue()) {
                return;
            }
            for (String propertyName : transChunkControlBreakDefItem
                    .getBreakKey()) {
                Object value = allChunkControlBreakKeyMap.get(propertyName);
                breakKeyValueMap.put(propertyName, value);
            }

            ControlBreakHandler<JobContext> controlBreakHandler = 
                transChunkControlBreakDefItem.getControlBreakHandler();

            // Rg[uCNN
            processControlBreak(controlBreakChunk.getJobContext(), jobStatus,
                    batchUpdateMapList, breakKeyValueMap, controlBreakHandler);

        }
    }
    
    /**
     * `N͈͂Ɗ֌WȂABLogics
     * Rg[uCNɂ Rg[uCNsB
     * 
     * @param controlBreakRowObject Rg[uCNpRowIuWFNg
     * @param jobContext WuReLXg
     * @param jobStatus WuXe[^X
     * @param batchUpdateMapList ob`XVXg
     */
    public void doControlBreak(ControlBreakRowObject controlBreakRowObject,
            JobContext jobContext, JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {

        List<List<String>> controlBreakKeyList = controlBreakRowObject
                .getControlBreakKeyList();

        Map<String, Object> allControlBreakKeyMap = controlBreakRowObject
                .getControlBreakMap();

        Map<String, Object> controlBreakKeyMap = new HashMap<String, Object>();
        if (controlBreakKeyList.size() > 0) {
            for (List<String> controlBreakKey : controlBreakKeyList) {
                controlBreakKeyMap.clear();
                if (controlBreakKey.size() == 0) {
                    continue;
                }
                if (!jobStatus.isContinue()) {
                    // Rg[uCNnhɂďIԂɂȂꍇɂ́A
                    // 㑱̃Rg[uCNsȂ
                    return;
                }
                ControlBreakHandler<JobContext> controlBreakHandler = 
                    controlBreakDef.getControlBreakHandler(controlBreakKey);
                for (String propertyName : controlBreakKey) {
                    Object value = allControlBreakKeyMap.get(propertyName);
                    controlBreakKeyMap.put(propertyName, value);
                }
                // Rg[uCNN
                processControlBreak(jobContext, jobStatus, batchUpdateMapList,
                        controlBreakKeyMap, controlBreakHandler);
            }
        }
    }

    /**
     * SRg[uCNNB ŏI`N̍Ō̃f[^̑S
     * Rg[uCNsB
     * 
     * @param controlBreakRowObject
     *            Rg[uCNpRowIuWFNg
     * @param jobContext
     *            WuReLXg
     * @param jobStatus
     *            WuXe[^X
     * @param batchUpdateMapList
     *            ob`XVXg
     */
    public void doAllChunkInternalControlBreak(
            ControlBreakRowObject controlBreakRowObject, JobContext jobContext,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        // `NRg[uCNʂтȂ
        Map<String, Object> allControlBreakKeyMap = controlBreakRowObject
                .getControlBreakMap();
        List<ControlBreakDefItem> controlBreakDefItemListReverseOrder = 
            controlBreakDef.getControlBreakDefItemList();

        HashMap<String, Object> breakKeyValueMap = 
            new HashMap<String, Object>();
        for (ControlBreakDefItem controlBreakDefItem
                : controlBreakDefItemListReverseOrder) {
            breakKeyValueMap.clear();
            if (controlBreakDefItem.getBreakKey().size() == 0) {
                continue;
            }

            // WuXe[^X`FbN
            if (!jobStatus.isContinue()) {
                return;
            }
            for (String propertyName : controlBreakDefItem.getBreakKey()) {
                Object value = allControlBreakKeyMap.get(propertyName);
                breakKeyValueMap.put(propertyName, value);
            }

            ControlBreakHandler<JobContext> controlBreakHandler =
                controlBreakDefItem.getControlBreakHandler();

            processControlBreak(jobContext, jobStatus, batchUpdateMapList,
                    breakKeyValueMap, controlBreakHandler);
        }
    }

    /**
     * Rg[uCNsB
     * 
     * @param jobContext
     *            WuReLXg
     * @param jobStatus
     *            WuXe[^X
     * @param batchUpdateMapList
     *            ob`XVXg
     * @param chunkControlBreakKeyMap
     *            Rg[uCNL[}bv
     * @param controlBreakHandler
     *            Rg[uCNnh
     */
    private void processControlBreak(JobContext jobContext,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList,
            Map<String, Object> chunkControlBreakKeyMap,
            ControlBreakHandler<JobContext> controlBreakHandler) {

        BLogicResult handlerResult = null;
        try {
            try {
                handlerResult = controlBreakHandler.handleControlBreak(
                        chunkControlBreakKeyMap, jobContext);

                blogicResultHandler.handle(handlerResult,
                        chunkControlBreakKeyMap, jobStatus, batchUpdateMapList);
            } catch (RuntimeException e) {
                // BLogicABLogicʃnhŔȌ
                BLogicException wrappingException = new BLogicException(e,
                        chunkControlBreakKeyMap, handlerResult);

                JobExceptionHandler handler = ExceptionHandlerUtil
                        .getJobExceptionHandler(wrappingException,
                                exceptionHandlerMap, defaultJobExceptionHandler);
                try {
                    handler.handlException(jobContext, wrappingException,
                            jobStatus);
                } catch (RuntimeException handlerException) {
                    log.error("[Exception in ExceptionHandler] Error JobID: "
                            + jobStatus.getJobId(), handlerException);
                    jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                }
            }
        } catch (Throwable throwable) {
            throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }

    /**
     * BLogicʃnhݒ肷B
     * 
     * @param blogicResultHandler
     *            BLogicʃnh
     */
    public void setBlogicResultHandler(
            BLogicResultHandler blogicResultHandler) {
        this.blogicResultHandler = blogicResultHandler;
    }

    /**
     * Rg[uCNL[`ݒ肷B
     * 
     * @param controlBreakDef Rg[uCNL[`
     */
    public void setControlBreakDef(ControlBreakDef controlBreakDef) {
        this.controlBreakDef = controlBreakDef;
    }

    /**
     * ftHgOnhݒ肷B
     * 
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
            JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    /**
     * Onh}bvݒ肷B
     * 
     * @param exceptionHandlerMap Onh}bv
     */
    public void setExceptionHandlerMap(
            Map<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * Throwablenhݒ肷B
     * 
     * @param throwableHandler Throwablenh
     */
    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

}
