/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * L[pNXB
 *
 * <p>L[vfoAoꂼ̗vfp[^Ƃă[J
 * [NB</p>
 * fÍA[J[œK؂Ȍ㑱sKv邽߁ÃNXł͉ȂB
 * 
 * <p>L[̗vf̏͂߂Oɂ́Aݒ肳ꂽOvZbTNB
 * OvZbTNۂɂ́AL[̐擪vf <code>JobContext</code> 
 * gpB</p>
 * 
 * <p>ׂẴL[̗vf̏IɁAݒ肳ꂽ㏈vZbTN
 * B㏈vZbTNۂɂ́AL[̍ŏIvf <code>JobContext
 * </code> gpB</p>
 *
 * <p>L[ɗvf݂Ȃꍇɂ́AOvZbTA㏈vZ
 * bT̗ƂNȂB</p>
 *
 */
public class QueueProcessor {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(QueueProcessor.class);

    /**
     * [J[B
     */
    private Workable<WorkUnit> worker = null;

    /**
     * L[vZbT̖́B
     */
    private String name = null;

    /**
     * OvZbTBL[̗vfOɋNB
     */
    private SupportProcessor preProcessor = null;

    /**
     * ㏈vZbTBL[̗vfׂďŋNB
     */
    private SupportProcessor postProcessor = null;

    /**
     * L[̏sB
     *
     * @param workQueue L[
     * @param jobStatus WuXe[^X
     */
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        printStartLog("QueueProcessor processing START", jobStatus);
        
        //  OvZbT̋Nς݃tO
        boolean donePreProcess = false;
        
        //@ς݂̃L[̑Ovf(㏈ŎgpŏIL[̗vf)
        WorkUnit preElement = null;
        
        while (true) {
            //  L[̗vf
            WorkUnit element = null;
            
            try {
                // L[珈Ώۃf[^擾B
                element = workQueue.take();
            } catch (QueueingException e) {
                // QueueingExceptionăWuԂsԂł͂Ȃ
                // RN^ňُ킪ĂƔfďIB
                // łȂ΁A[Jُ̈ƌȂėOthrowB
                if (!jobStatus.isExecuting()) {
                    break;
                }
                throw e;
            }

            // element͂܂ŏʂĂnullł͂ȂƂ݂Ȃ邽
            // null`FbN͍sȂB
            if (element.isEndMark()) {
                if (preElement != null && postProcessor != null) {
                    postProcessor.process(preElement.getJobContext(),
                            jobStatus);
                }
                break;
            }

            if (!donePreProcess && preProcessor != null) {
                preProcessor.process(element.getJobContext(), jobStatus);
                if (!jobStatus.isContinue()) {
                    break;
                }

                donePreProcess = true;
            }
            
            // {
            worker.work(element, jobStatus);
            if (!jobStatus.isContinue()) {
                break;
            }
            
            preElement = element;
        }

        printEndLog("QueueProcessor processing END", jobStatus);
    }

    /**
     * [J[ݒ肷B
     *
     * @param worker [J[
     */
    public void setWorker(Workable<WorkUnit> worker) {
        this.worker = worker;
    }

    /**
     * ̂ݒ肷B
     *
     * @param name 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * ㏈vZbTݒ肷B
     *
     * @param postProcessor ㏈vZbT
     */
    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    /**
     * OvZbTݒ肷B
     *
     * @param preProcessor OvZbT
     */
    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
    
    /**
     * QueueProcessor̊JnOo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     */
    protected void printStartLog(String message, JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder(message);
            logStr.append(" : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [QueueProcessorName=");
            logStr.append(name);
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * QueueProcessoȑIOo͂B
     * 
     * @param message bZ[W
     * @param jobStatus WuXe[^X
     */
    protected void printEndLog(String message, JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder(message);
            logStr.append(" : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [QueueProcessorName=");
            logStr.append(name);
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }
}
