/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.struts.form.FormEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/**
 * rWlXWbNo͏񔽉fNXB
 *
 * <p>
 *  BLogicIOPlugInɂĐꂽBLogicResourcesƂɁA
 *  Webw̃IuWFNgƁArWlXWbNԂ̃f[^̃}bsOsB<br>
 *  Webw̓͂̓NGXg(request)AZbV(session)A
 *  T[ubgReLXg(application)ΏۂƂȂB<br>
 *  rWlXWbN̏o͂̓NGXg(request)AZbV(session)
 *  ΏۂƂȂBrWlXWbNT[ubgReLXgւ̏o͂
 *  T|[gĂȂB
 * </p>
 * <p>
 *  AbstractBLogicMapper̃TuNXƂāA
 *  ftHgł̃NX񋟂Ă邪A
 *  struts-config.xmlBLogicIOPlugIn̐ݒɂāA
 *  ̋@\u邱ƂłB
 *  ̍ہAAbstractBLogicMapper܂BLogicMapper
 *  prWlXWbNo͏񔽉fNX쐬KvB
 *  grWlXWbNo͏񔽉fNXł́A
 *  blogic-io.xmlsourcerequestAsessionAapplicationA
 *  destrequestAsessionȊO
 *  Cӂ̕w肵ꍇ̓͒l擾Ao͒lfB<br>
 *  ͒l擾̃\bh́A
 *  "getValueFrom" + sourceɎw肷镶ƂB
 *  source"factory"Ǝw肷ꍇA\bhgetValueFromFactoryƂȂB
 *  ͑SĂ̓͒l擾\bhŋʂŁA
 *  getValueFromForm()\bhƓƂB<br>
 *  o͒lf̃\bh́A
 *  "setValueTo" + destɎw肷镶ƂB
 *  dest"factory"Ǝw肷ꍇA\bhgetValueToFactoryƂȂB
 *  ͑SĂ̏o͒lf\bhŋʂŁA
 *  getValueToForm()\bhƓƂB<br>
 *  Al̎擾AActionForm̏ꍇ̓lXgvpeBw
 *  邱Ƃ\łB
 * </p>
 * <p>
 *  rWlXWbNo͏񔽉fNX̓ւE
 *  struts-config.xml̋Lq@ɂẮABLogicIOPlugInQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.service.thin.AbstractBLogicMapper
 * @see jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn
 *
 */
public class BLogicMapper extends AbstractBLogicMapper {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BLogicMapper.class);

    /**
     * \[Xt@CȂꍇ̃G[R[hB
     */
    private static final String ERROR_RESOURCES_FILE = "errors.resources.file";

    /**
     * RXgN^B
     */
    public BLogicMapper(){
        
    }
    
    /**
     * RXgN^B
     * @param resources \[X̃pX
     */
    public BLogicMapper(String resources) {
        if (resources == null || "".equals(resources)) {
            log.error("resources file location is not specified");
            throw new IllegalArgumentException(ERROR_RESOURCES_FILE);
        }
    }
    
    /**
     * NGXgw肳ꂽvpeBl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    @Override
    public Object getValueFromRequest(String propName,
            HttpServletRequest request, HttpServletResponse response) {

        if (propName == null || "".equals(propName)) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw new IllegalArgumentException();
        }

        // NGXgl擾
        Object value = request.getAttribute(propName);

        if (log.isDebugEnabled()) {
            if (request.getAttribute(propName) == null) {
                log.debug("Request's attribute is null:key =[" + propName
                            + "]");
            }
        }

        return value;
    }

    /**
     * tH[w肳ꂽvpeBl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    public Object getValueFromForm(String propName, HttpServletRequest request,
            @SuppressWarnings("unused") HttpServletResponse response) throws PropertyAccessException {
        // tH[擾
        ActionForm form = getActionForm(request);

        // Forml擾
        Object value = null;
        try {
            value = BeanUtil.getBeanProperty(form, propName);
        } catch (PropertyAccessException e) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw e;
        }
        return value;
    }

    /**
     * ZbVw̃vpeBL[ɒl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    @Override
    public Object getValueFromSession(String propName,
            HttpServletRequest request, HttpServletResponse response) {

        if (propName == null || "".equals(propName)) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw new IllegalArgumentException();
        }

        // ZbV̎擾
        HttpSession session = request.getSession(true);
        // ZbVl擾
        Object value = session.getAttribute(propName);

        if (log.isDebugEnabled()) {
            if (session.getAttribute(propName) == null) {
                log.debug("Session's attribute is null:key =[" + propName
                            + "]");
            }
        }
        return value;
    }

    /**
     * NGXg̎w肳ꂽvpeBɒli[B
     *
     * @param value o͒l
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    @SuppressWarnings("unchecked")
    @Override
    public void setValueToRequest(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response) {

        if (propName == null || "".equals(propName)) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw new IllegalArgumentException();
        }

        if (log.isDebugEnabled()) {
            Enumeration<String> enumeration = request.getAttributeNames();
            int existFlag = 0;
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                if (key.equals(propName)) {
                    existFlag = 1;
                    break;
                }
            }
            if (existFlag != 1) {
                log.debug("Request's key does not exist:key =[" + propName
                        + "]");
            }
        }
        // NGXgɒli[
        request.setAttribute(propName, value);
    }

    /**
     * tH[̎w肳ꂽvpeBɒli[B<br>
     * tH[FormEx̃CX^Xł΁AmodifiedtOtrue
     * ݒ肷B
     *
     * @param value o͒l
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    public void setValueToForm(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response)
                throws PropertyAccessException {
        // tH[擾
        ActionForm form = getActionForm(request);

        // tH[ɒli[
        try {
            BeanUtil.setBeanProperty(form, propName, value);
            if (form instanceof FormEx) {
                FormEx formEx = (FormEx) form;
                formEx.setModified(true);
            }
        } catch (PropertyAccessException e) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw e;
        }
    }

    /**
     * ZbVɎw̃vpeBL[ɒli[B
     *
     * @param value o͒l
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    @SuppressWarnings("unchecked")
    @Override
    public void setValueToSession(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response) {

        if (propName == null || "".equals(propName)) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw new IllegalArgumentException();
        }

        // ZbV̎擾
        HttpSession session = request.getSession(true);

        if (log.isDebugEnabled()) {
            Enumeration<String> enumeration = session.getAttributeNames();
            int existFlag = 0;
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                if (key.equals(propName)) {
                    existFlag = 1;
                    break;
                }
            }
            if (existFlag != 1) {
                log.debug("Session's key does not exist:key =[" + propName
                        + "]");
            }
        }
        // ZbVɒli[
        session.setAttribute(propName, value);
    }

    /**
     * NGXg܂̓ZbVɊi[ĂActionForm
     * CX^X擾B
     *
     * @param request HTTPNGXg
     * @return ActionFormCX^X
     */
    protected ActionForm getActionForm(HttpServletRequest request) {

        ActionMapping mapping = (ActionMapping) request
                .getAttribute(Globals.MAPPING_KEY);
        ActionForm form = null;
        if ("request".equals(mapping.getScope())) {
            form = (ActionForm) request.getAttribute(mapping.getAttribute());
        } else {
            HttpSession session = request.getSession();
            form = (ActionForm) session.getAttribute(mapping.getAttribute());
        }
        // ActionFormԋp
        return form;
    }

    /**
     * T[ubgReLXgw̃vpeBL[ɒl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    @Override
    public Object getValueFromApplication(String propName,
            HttpServletRequest request, HttpServletResponse response) {

        if (propName == null || "".equals(propName)) {
            log.error("illegal argument:propName = [" + propName + "]");
            throw new IllegalArgumentException();
        }

        // T[ubgReLXg̎擾
        HttpSession session = request.getSession(true);
        ServletContext context = session.getServletContext();
        // ZbVl擾
        Object value = context.getAttribute(propName);

        if (log.isDebugEnabled()) {
            if (value == null) {
                log.debug("ServletContext's attribute is null:key =[" + propName
                            + "]");
            }
        }
        return value;
    }
}
