/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;

public class TraceObject {
    protected static final int CALLABLE_STATEMENT = 0;
    protected static final int CONNECTION = 1;
    protected static final int DATABASE_META_DATA = 2;
    protected static final int PREPARED_STATEMENT = 3;
    protected static final int RESULT_SET = 4;
    protected static final int RESULT_SET_META_DATA = 5;
    protected static final int SAVEPOINT = 6;
    protected static final int SQL_EXCEPTION = 7;
    protected static final int STATEMENT = 8;
    protected static final int BLOB = 9;
    protected static final int CLOB = 10;
    protected static final int PARAMETER_META_DATA = 11;
    protected static final int DATA_SOURCE = 12;
    protected static final int XA_DATA_SOURCE = 13;
    protected static final int XID = 14;
    protected static final int ARRAY = 15;
    private static final int LAST = 16;
    private static final int[] ID = new int[16];
    private static final String[] PREFIX = new String[]{"call", "conn", "dbMeta", "prep", "rs", "rsMeta", "sp", "ex", "stat", "blob", "clob", "pMeta", "ds", "xads", "xid", "ar"};
    private Trace trace;
    private int type;
    private int id;
    static /* synthetic */ Class class$org$h2$message$TraceObject;

    protected void setTrace(Trace trace, int n, int n2) {
        this.trace = trace;
        this.type = n;
        this.id = n2;
    }

    public int getTraceId() {
        return this.id;
    }

    public String getTraceObjectName() {
        return PREFIX[this.type] + this.id;
    }

    protected int getNextId(int n) {
        int n2 = n;
        int n3 = ID[n2];
        ID[n2] = n3 + 1;
        return n3;
    }

    protected boolean isDebugEnabled() {
        return this.trace.isDebugEnabled();
    }

    protected boolean isInfoEnabled() {
        return this.trace.isInfoEnabled();
    }

    protected void debugCodeAssign(String string, int n, int n2, String string2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(string + " " + PREFIX[n] + n2 + " = " + this.getTraceObjectName() + "." + string2 + ";");
        }
    }

    protected void debugCodeCall(String string) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "();");
        }
    }

    protected void debugCodeCall(String string, long l) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "(" + l + ");");
        }
    }

    protected void debugCodeCall(String string, String string2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "(" + this.quote(string2) + ");");
        }
    }

    protected void debugCode(String string) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string);
        }
    }

    protected String quote(String string) {
        return StringUtils.quoteJavaString(string);
    }

    protected String quoteTime(Time time) {
        if (time == null) {
            return "null";
        }
        return "Time.valueOf(\"" + time.toString() + "\")";
    }

    protected String quoteTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "null";
        }
        return "Timestamp.valueOf(\"" + timestamp.toString() + "\")";
    }

    protected String quoteDate(Date date) {
        if (date == null) {
            return "null";
        }
        return "Date.valueOf(\"" + date.toString() + "\")";
    }

    protected String quoteBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "null";
        }
        return "new BigDecimal(\"" + bigDecimal.toString() + "\")";
    }

    protected String quoteBytes(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return "org.h2.util.ByteUtils.convertStringToBytes(\"" + ByteUtils.convertBytesToString(byArray) + "\")";
    }

    protected String quoteArray(String[] stringArray) {
        return StringUtils.quoteJavaStringArray(stringArray);
    }

    protected String quoteIntArray(int[] nArray) {
        return StringUtils.quoteJavaIntArray(nArray);
    }

    protected String quoteMap(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "new Map()";
        }
        StringBuffer stringBuffer = new StringBuffer("new Map() /* ");
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                stringBuffer.append(string);
                stringBuffer.append(':');
                Class clazz = (Class)entry.getValue();
                stringBuffer.append(clazz.getName());
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString() + ": " + map.toString());
        }
        stringBuffer.append("*/");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLException logAndConvert(Exception exception) {
        if (SysProperties.LOG_ALL_ERRORS) {
            Class clazz = class$org$h2$message$TraceObject == null ? (class$org$h2$message$TraceObject = TraceObject.class$("org.h2.message.TraceObject")) : class$org$h2$message$TraceObject;
            synchronized (clazz) {
                try {
                    Writer writer = IOUtils.getWriter(FileUtils.openFileOutputStream(SysProperties.LOG_ALL_ERRORS_FILE, true));
                    PrintWriter printWriter = new PrintWriter(writer);
                    exception.printStackTrace(printWriter);
                    printWriter.close();
                    writer.close();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (this.trace == null) {
            TraceSystem.traceThrowable(exception);
        } else {
            if (exception instanceof SQLException) {
                this.trace.error("SQLException", exception);
                return (SQLException)exception;
            }
            this.trace.error("Uncaught Exception", exception);
        }
        return Message.convert(exception);
    }

    public static String toString(String string, ObjectArray objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (objectArray != null && objectArray.size() > 0) {
            stringBuffer.append(" {");
            for (int i = 0; i < objectArray.size(); ++i) {
                try {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(i + 1);
                    stringBuffer.append(": ");
                    ParameterInterface parameterInterface = (ParameterInterface)objectArray.get(i);
                    if (parameterInterface == null || parameterInterface.getParamValue() == null) {
                        stringBuffer.append("unset");
                        continue;
                    }
                    stringBuffer.append(parameterInterface.getParamValue().getSQL());
                    continue;
                }
                catch (SQLException sQLException) {
                    stringBuffer.append("/* ");
                    stringBuffer.append(i + 1);
                    stringBuffer.append(": ");
                    stringBuffer.append(sQLException.toString());
                    stringBuffer.append("*/ ");
                }
            }
            stringBuffer.append("};");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

