/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class BeanNameAutoProxyCreator
extends AbstractAutoProxyCreator {
    private List beanNames;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public void setBeanNames(String[] beanNames) {
        Assert.notEmpty(beanNames, "'beanNames' must not be empty");
        this.beanNames = new ArrayList(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            this.beanNames.add(StringUtils.trimWhitespace(beanNames[i]));
        }
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        if (this.beanNames != null) {
            Iterator it = this.beanNames.iterator();
            while (it.hasNext()) {
                String mappedName = (String)it.next();
                if ((class$org$springframework$beans$factory$FactoryBean == null ? BeanNameAutoProxyCreator.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass)) {
                    if (!mappedName.startsWith("&")) continue;
                    mappedName = mappedName.substring("&".length());
                }
                if (!this.isMatch(beanName, mappedName)) continue;
                return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
            }
        }
        return DO_NOT_PROXY;
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, beanName);
    }
}

