/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.core.ProducerCallback;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class JmsTemplate
extends JmsDestinationAccessor
implements JmsOperations {
    public static final long RECEIVE_TIMEOUT_NO_WAIT = -1L;
    public static final long RECEIVE_TIMEOUT_INDEFINITE_WAIT = 0L;
    private final JmsTemplateResourceFactory transactionalResourceFactory = new JmsTemplateResourceFactory();
    private Object defaultDestination;
    private MessageConverter messageConverter;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal = false;
    private long receiveTimeout = 0L;
    private boolean explicitQosEnabled = false;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;

    public JmsTemplate() {
        this.initDefaultStrategies();
    }

    public JmsTemplate(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter());
    }

    public void setDefaultDestination(Destination destination) {
        this.defaultDestination = destination;
    }

    public Destination getDefaultDestination() {
        return this.defaultDestination instanceof Destination ? (Destination)this.defaultDestination : null;
    }

    public void setDefaultDestinationName(String destinationName) {
        this.defaultDestination = destinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestination instanceof String ? (String)this.defaultDestination : null;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryMode = deliveryPersistent ? 2 : 1;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    private void checkDefaultDestination() throws IllegalStateException {
        if (this.defaultDestination == null) {
            throw new IllegalStateException("No defaultDestination or defaultDestinationName specified. Check configuration of JmsTemplate.");
        }
    }

    private void checkMessageConverter() throws IllegalStateException {
        if (this.getMessageConverter() == null) {
            throw new IllegalStateException("No messageConverter registered. Check configuration of JmsTemplate.");
        }
    }

    public Object execute(SessionCallback action) throws JmsException {
        return this.execute(action, false);
    }

    public Object execute(SessionCallback action, boolean startConnection) throws JmsException {
        Object object;
        Assert.notNull(action, "Callback object must not be null");
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = ConnectionFactoryUtils.doGetTransactionalSession(this.getConnectionFactory(), this.transactionalResourceFactory, startConnection);
            if (sessionToUse == null) {
                conToClose = this.createConnection();
                sessionToClose = this.createSession(conToClose);
                if (startConnection) {
                    conToClose.start();
                }
                sessionToUse = sessionToClose;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS Session: " + sessionToUse));
            }
            object = action.doInJms(sessionToUse);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(sessionToClose);
                ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
                throw throwable;
            }
        }
        JmsUtils.closeSession(sessionToClose);
        ConnectionFactoryUtils.releaseConnection(conToClose, this.getConnectionFactory(), startConnection);
        return object;
    }

    public Object execute(ProducerCallback action) throws JmsException {
        if (this.getDefaultDestinationName() != null) {
            return this.execute(this.getDefaultDestinationName(), action);
        }
        return this.execute(this.getDefaultDestination(), action);
    }

    public Object execute(final Destination destination, final ProducerCallback action) throws JmsException {
        Assert.notNull(action, "Callback object must not be null");
        return this.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                MessageProducer producer = JmsTemplate.this.createProducer(session, destination);
                try {
                    Object object = action.doInJms(session, producer);
                    return object;
                }
                finally {
                    JmsUtils.closeMessageProducer(producer);
                }
            }
        }, false);
    }

    public Object execute(final String destinationName, final ProducerCallback action) throws JmsException {
        Assert.notNull(action, "Callback object must not be null");
        return this.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                MessageProducer producer = JmsTemplate.this.createProducer(session, destination);
                try {
                    Object object = action.doInJms(session, producer);
                    return object;
                }
                finally {
                    JmsUtils.closeMessageProducer(producer);
                }
            }
        }, false);
    }

    public void send(MessageCreator messageCreator) throws JmsException {
        this.checkDefaultDestination();
        if (this.getDefaultDestination() != null) {
            this.send(this.getDefaultDestination(), messageCreator);
        } else {
            this.send(this.getDefaultDestinationName(), messageCreator);
        }
    }

    public void send(final Destination destination, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        }, false);
    }

    public void send(final String destinationName, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                JmsTemplate.this.doSend(session, destination, messageCreator);
                return null;
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Session session, Destination destination, MessageCreator messageCreator) throws JMSException {
        Assert.notNull(messageCreator, "MessageCreator must not be null");
        MessageProducer producer = this.createProducer(session, destination);
        try {
            Message message = messageCreator.createMessage(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending created message: " + message));
            }
            this.doSend(producer, message);
            if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary(session);
            }
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.isExplicitQosEnabled()) {
            producer.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            producer.send(message);
        }
    }

    public void convertAndSend(Object message) throws JmsException {
        this.checkDefaultDestination();
        if (this.getDefaultDestination() != null) {
            this.convertAndSend(this.getDefaultDestination(), message);
        } else {
            this.convertAndSend(this.getDefaultDestinationName(), message);
        }
    }

    public void convertAndSend(Destination destination, final Object message) throws JmsException {
        this.checkMessageConverter();
        this.send(destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getMessageConverter().toMessage(message, session);
            }
        });
    }

    public void convertAndSend(String destinationName, final Object message) throws JmsException {
        this.checkMessageConverter();
        this.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return JmsTemplate.this.getMessageConverter().toMessage(message, session);
            }
        });
    }

    public void convertAndSend(Object message, MessagePostProcessor postProcessor) throws JmsException {
        this.checkDefaultDestination();
        if (this.getDefaultDestination() != null) {
            this.convertAndSend(this.getDefaultDestination(), message, postProcessor);
        } else {
            this.convertAndSend(this.getDefaultDestinationName(), message, postProcessor);
        }
    }

    public void convertAndSend(Destination destination, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        this.checkMessageConverter();
        this.send(destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message msg = JmsTemplate.this.getMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(msg);
            }
        });
    }

    public void convertAndSend(String destinationName, final Object message, final MessagePostProcessor postProcessor) throws JmsException {
        this.checkMessageConverter();
        this.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message msg = JmsTemplate.this.getMessageConverter().toMessage(message, session);
                return postProcessor.postProcessMessage(msg);
            }
        });
    }

    public Message receive() throws JmsException {
        this.checkDefaultDestination();
        if (this.getDefaultDestination() != null) {
            return this.receive(this.getDefaultDestination());
        }
        return this.receive(this.getDefaultDestinationName());
    }

    public Message receive(Destination destination) throws JmsException {
        return this.receiveSelected(destination, null);
    }

    public Message receive(String destinationName) throws JmsException {
        return this.receiveSelected(destinationName, null);
    }

    public Message receiveSelected(String messageSelector) throws JmsException {
        this.checkDefaultDestination();
        if (this.getDefaultDestination() != null) {
            return this.receiveSelected(this.getDefaultDestination(), messageSelector);
        }
        return this.receiveSelected(this.getDefaultDestinationName(), messageSelector);
    }

    public Message receiveSelected(final Destination destination, final String messageSelector) throws JmsException {
        return (Message)this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                return JmsTemplate.this.doReceive(session, destination, messageSelector);
            }
        }, true);
    }

    public Message receiveSelected(final String destinationName, final String messageSelector) throws JmsException {
        return (Message)this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName);
                return JmsTemplate.this.doReceive(session, destination, messageSelector);
            }
        }, true);
    }

    protected Message doReceive(Session session, Destination destination, String messageSelector) throws JMSException {
        return this.doReceive(session, this.createConsumer(session, destination, messageSelector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message doReceive(Session session, MessageConsumer consumer) throws JMSException {
        try {
            long timeout = this.getReceiveTimeout();
            JmsResourceHolder resourceHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource(this.getConnectionFactory());
            if (resourceHolder != null && resourceHolder.hasTimeout()) {
                timeout = resourceHolder.getTimeToLiveInMillis();
            }
            Message message = null;
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout > 0L ? consumer.receive(timeout) : consumer.receive());
            if (session.getTransacted()) {
                if (this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary(session);
                }
            } else if (this.isClientAcknowledge(session) && message != null) {
                message.acknowledge();
            }
            Message message2 = message;
            return message2;
        }
        finally {
            JmsUtils.closeMessageConsumer(consumer);
        }
    }

    public Object receiveAndConvert() throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receive());
    }

    public Object receiveAndConvert(Destination destination) throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receive(destination));
    }

    public Object receiveAndConvert(String destinationName) throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receive(destinationName));
    }

    public Object receiveSelectedAndConvert(String messageSelector) throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receiveSelected(messageSelector));
    }

    public Object receiveSelectedAndConvert(Destination destination, String messageSelector) throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receiveSelected(destination, messageSelector));
    }

    public Object receiveSelectedAndConvert(String destinationName, String messageSelector) throws JmsException {
        this.checkMessageConverter();
        return this.doConvertFromMessage(this.receiveSelected(destinationName, messageSelector));
    }

    protected Object doConvertFromMessage(Message message) {
        if (message != null) {
            try {
                return this.getMessageConverter().fromMessage(message);
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }
        return null;
    }

    public Object browse(BrowserCallback action) throws JmsException {
        if (this.getDefaultDestinationName() != null) {
            return this.browse(this.getDefaultDestinationName(), action);
        }
        Destination defaultDestination = this.getDefaultDestination();
        if (!(defaultDestination instanceof Queue)) {
            throw new IllegalStateException("defaultDestination does not correspond to a Queue. Check configuration of JmsTemplate.");
        }
        return this.browse((Queue)defaultDestination, action);
    }

    public Object browse(Queue queue, BrowserCallback action) throws JmsException {
        return this.browseSelected(queue, null, action);
    }

    public Object browse(String queueName, BrowserCallback action) throws JmsException {
        return this.browseSelected(queueName, null, action);
    }

    public Object browseSelected(String messageSelector, BrowserCallback action) throws JmsException {
        if (this.getDefaultDestinationName() != null) {
            return this.browseSelected(this.getDefaultDestinationName(), messageSelector, action);
        }
        Destination defaultDestination = this.getDefaultDestination();
        if (!(defaultDestination instanceof Queue)) {
            throw new IllegalStateException("defaultDestination does not correspond to a Queue. Check configuration of JmsTemplate.");
        }
        return this.browseSelected((Queue)defaultDestination, messageSelector, action);
    }

    public Object browseSelected(final Queue queue, final String messageSelector, final BrowserCallback action) throws JmsException {
        Assert.notNull(action, "Callback object must not be null");
        return this.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                QueueBrowser browser = JmsTemplate.this.createBrowser(session, queue, messageSelector);
                try {
                    Object object = action.doInJms(session, browser);
                    return object;
                }
                finally {
                    JmsUtils.closeQueueBrowser(browser);
                }
            }
        }, true);
    }

    public Object browseSelected(final String queueName, final String messageSelector, final BrowserCallback action) throws JmsException {
        Assert.notNull(action, "Callback object must not be null");
        return this.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                Queue queue = (Queue)JmsTemplate.this.getDestinationResolver().resolveDestinationName(session, queueName, false);
                QueueBrowser browser = JmsTemplate.this.createBrowser(session, queue, messageSelector);
                try {
                    Object object = action.doInJms(session, browser);
                    return object;
                }
                finally {
                    JmsUtils.closeQueueBrowser(browser);
                }
            }
        }, true);
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        return holder.getConnection();
    }

    protected Session getSession(JmsResourceHolder holder) {
        return holder.getSession();
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return this.isSessionTransacted() && !ConnectionFactoryUtils.isSessionTransactional(session, this.getConnectionFactory());
    }

    protected MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        MessageProducer producer = this.doCreateProducer(session, destination);
        if (!this.isMessageIdEnabled()) {
            producer.setDisableMessageID(true);
        }
        if (!this.isMessageTimestampEnabled()) {
            producer.setDisableMessageTimestamp(true);
        }
        return producer;
    }

    protected MessageProducer doCreateProducer(Session session, Destination destination) throws JMSException {
        return session.createProducer(destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
        if (this.isPubSubDomain()) {
            return session.createConsumer(destination, messageSelector, this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, messageSelector);
    }

    protected QueueBrowser createBrowser(Session session, Queue queue, String messageSelector) throws JMSException {
        return session.createBrowser(queue, messageSelector);
    }

    private class JmsTemplateResourceFactory
    implements ConnectionFactoryUtils.ResourceFactory {
        private JmsTemplateResourceFactory() {
        }

        public Connection getConnection(JmsResourceHolder holder) {
            return JmsTemplate.this.getConnection(holder);
        }

        public Session getSession(JmsResourceHolder holder) {
            return JmsTemplate.this.getSession(holder);
        }

        public Connection createConnection() throws JMSException {
            return JmsTemplate.this.createConnection();
        }

        public Session createSession(Connection con) throws JMSException {
            return JmsTemplate.this.createSession(con);
        }

        public boolean isSynchedLocalTransactionAllowed() {
            return JmsTemplate.this.isSessionTransacted();
        }
    }
}

