/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;

import jp.terasoluna.fw.web.RequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.IterateTag;

/**
 * <p>g <code>link</code> ^OB</p>
 *
 * <p>
 *  <code>Struts</code> ̒񋟂 <code>&lt;html:link&gt;</code> ^OgB
 *  @\ƂāAANV <code>URL</code> ɃLbVp_
 *  <code>ID</code> ǉB
 *  lXgĂȂ<code></code>iterateTag</code>
 *  <code>BODY</code><code>LinkTag</code>gpƂ̂
 *  <code>indexed</code>A<code>indexId</code>LƂȂB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p><code>&lt;html:link&gt;</code>^O<code>API</code> QƁB</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p> <code>&lt;html:link&gt;</code> ^O <code>API</code> QƁB</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p> <code>&lt;html:link&gt;</code> ^O <code>API</code> QƁB</p>
 *
 *
 *
 */
public class LinkTag extends org.apache.struts.taglib.html.LinkTag {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -2143604832271336809L;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(LinkTag.class);
    
    /**
     * LbVp_ID̃p[^B
     */
    private static final String RANDOM_ID_KEY = RandomUtil.RANDOM_ID_KEY;

    /**
     * <p>URLɃLbVp_IDǉB</p>
     *
     * <p>zbgX|bgȂ߁A<code>Struts 1.2.4</code> 
     * <code>LinkTag.calculate()</code> ̃R[hRs[ĕύXĂB
     * <code>Struts</code> ̃o[WύXꍇ
     * KvƂȂ̂Œӂ邱ƁB</p>
     *
     * @return w
     * @exception JspException G[Ƃ
     */
    @SuppressWarnings("unchecked")
    @Override
    protected String calculateURL() throws JspException {

        // Identify the parameters we will add to the completed URL
        Map<String, String> params = TagUtils.getInstance().computeParameters(
                pageContext, paramId, paramName, paramProperty, paramScope,
                name, property, scope, transaction);

        // ========== ygӏz==========
        if (params == null) {
            params = new HashMap<String, String>();
        }

        //łɃ_ID݂ꍇ͍폜B
        forward = RequestUtil.deleteUrlParam(forward, RANDOM_ID_KEY);
        href = RequestUtil.deleteUrlParam(href, RANDOM_ID_KEY);
        page = RequestUtil.deleteUrlParam(page, RANDOM_ID_KEY);
        action = RequestUtil.deleteUrlParam(action, RANDOM_ID_KEY);

        //p[^}bvɃ_IDǉB
        params.put(RANDOM_ID_KEY, RandomUtil.generateRandomID());

        // if "indexed=true", add "index=x" parameter to query string
        // * @since Struts 1.1
        if (indexed) {

           // look for outer iterate tag
           IterateTag iterateTag =
               (IterateTag) findAncestorWithClass(this, IterateTag.class);
           if (iterateTag == null) {
               // iterateTagbodyŎgpĂȂꍇ͗O𓊂
               JspException e = new JspException
                   (messages.getMessage("indexed.noEnclosingIterate"));
               TagUtils.getInstance().saveException(pageContext, e);
               
               log.error("iterateTag is null.");
               throw e;
           }

           if (indexId != null) {
               params.put(indexId, Integer.toString(iterateTag.getIndex()));
           } else {
               params.put("index", Integer.toString(iterateTag.getIndex()));
           }
        }
        // ========== ygӏz܂==========

        String url = null;
        try {
            url = TagUtils.getInstance().computeURLWithCharEncoding(
                    pageContext, forward, href, page, action, module, params,
                    anchor, false, useLocalEncoding);
        } catch (MalformedURLException e) {
            TagUtils.getInstance().saveException(pageContext, e);
            
            log.error("Malformed URL has occurred.");
            throw new JspException
                (messages.getMessage("rewrite.url", e.toString()));
        }
        return (url);

    }
}
