/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.sample.service.blogic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import jp.terasoluna.fw.batch.commonj.init.JobStarter;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;

/**
 * 
 * t@CAbv[hAbatchNrWlXWbNNXB
 *
 */
public class StartBatchBLogicImpl implements BLogic<Map<String, Object>> {
    
    /**
     * t@CAbv[h̃fBNg
     */
    private static String FILEUP_DIR = "tmp/";
    
    /**
     * 펞IR[h
     */
    private static int NORMAL_END_CODE = 0;
    
    
    /**
     * ُ펞IR[h
     */
    private static int ERROR_END_CODE = 400;


    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(StartBatchBLogicImpl.class);
    
    
    /**
     * WuX^[^
     * SpringɂCX^Xݒ肳B
     */
    private JobStarter jobStarter = null;
    
    
    /**
     * rWlXWbN̎sƂăt@CAbv[hƃob`̋Ns
     * @param map vpeB
     * @return rWlXWbNʃIuWFNg
     */
    public BLogicResult execute(Map<String, Object> map) {
        
        //f[^t@CtH[t@C擾
        FormFile fileUp = (FormFile) map.get("fileUp");
        
        //t@C
        String fileName = fileUp.getFileName();
        
        //f[^t@Czu
        int fileUPEndCode = fileUpLoad(fileUp);
        
        //t@CAbv[hȂۂُ̈I
        if (fileUPEndCode == ERROR_END_CODE) {
            //ʕԋp
            
            //rWlXWbŇʃIuWFNg
            BLogicResult result = new BLogicResult();
            
            //rWlXWbŇʕ"failure"ݒ肵AԋpB
            result.setResultString("failure");
            
            //\郁bZ[W̐Aݒ
            BLogicMessages messages = new BLogicMessages();
            
            //bZ[Wɕ\t@C̐ݒ
            String[] mesargs = {fileName};
            
            //IR[h0łȂꍇFُ탁bZ[Wݒ
             messages.add("fileUp.error",
                        new BLogicMessage("fileUp.error", mesargs));
            
            //G[bZ[W̐ݒ
            result.setErrors(messages);
            
            return result;
        }
            
        //f[^捞WuN
        //f[^t@C̃pXRƂAf[^捞cvZWu(JOB01)NB
        String path = FILEUP_DIR + fileUp.getFileName();
        String[] args = {path};
        
        //WűN
        int jobEndCode = jobStarter.execute("Job01", "sample/JOB01.xml", args);
        
        //rWlXWbŇʃIuWFNg
        BLogicResult result = new BLogicResult();
        
        //\郁bZ[W̐Aݒ
        BLogicMessages messages = new BLogicMessages();
        
        //bZ[Wɕ\t@C̐ݒ
        String[] mesargs = {fileName};
        
        //WȕIR[h󂯎A^ُ탁bZ[W\B
        //IR[h0̏ꍇF탁bZ[Wݒ肷
        if (jobEndCode == NORMAL_END_CODE) {
            
            //rWlXWbŇʕ"success"ݒ肵AԋpB	
            result.setResultString("success");
            
            //bZ[W̐ݒ
            messages.add("batch.success",
                    new BLogicMessage("batch.success", mesargs));
            result.setMessages(messages);
        }
        //IR[h0łȂꍇFُ탁bZ[Wݒ
        else {

            //rWlXWbŇʕ"failure"ݒ肵AԋpB	
            result.setResultString("failure");
            
            //G[bZ[W̐ݒ
            messages.add("batch.error",
                    new BLogicMessage("batch.error", mesargs));
            result.setErrors(messages);
        }
        
        return result;
    }
    
    /**
     * f[^t@Ct@CAbv[hs
     * @param fileUp Abv[ht@C̃tH[t@C
     */
    private int fileUpLoad(FormFile fileUp) {
        
        //̓Xg[obt@
        BufferedInputStream inBuffer = null;
        
        //o̓Xg[obt@
        BufferedOutputStream outBuffer = null;
        
        
        //t@C
        String fileName = fileUp.getFileName();
        
        //.csvłȂB邢̓t@CTCY0łꍇɂُ͈IR[hԂ
        if (! (fileName.endsWith(".csv") || fileName.endsWith(".CSV"))
                || fileUp.getFileSize() == 0) {
            return ERROR_END_CODE;
        }
        
        //͒l̓f[^t@CwtmpxtH_ɔzuB				
        try {	
            //getInputStream\bhgpA̓Xg[擾
            InputStream is = fileUp.getInputStream();
            
            //̓Xg[obt@O
            inBuffer = new BufferedInputStream(is);
            

            //t@CAbv[h̃pXݒ
            String path = FILEUP_DIR + fileUp.getFileName();
            
            //t@C̃Abv[hw肵āAo̓Xg[𐶐
            FileOutputStream fos = new FileOutputStream(path);
        
            
            //o̓Xg[obt@O
            outBuffer = new BufferedOutputStream(fos);
            
            
            //̓f[^ȂȂ܂œo͏s
            int data = 0;
            while ((data = inBuffer.read()) != -1) {
                outBuffer.write(data);
            }
            
        } catch (FileNotFoundException e) {
            //\郁bZ[W̐Aݒ
            BLogicMessages messages = new BLogicMessages();
            messages.add("fileUp.uploadingError",
                    new BLogicMessage("fileUp.uploadingError"));
            log.error(messages);
            return ERROR_END_CODE;
        } catch (IOException e) {
            //\郁bZ[W̐Aݒ
            BLogicMessages messages = new BLogicMessages();
            messages.add("fileUp.uploadingError",
                    new BLogicMessage("fileUp.uploadingError"));
            log.error(messages);
            return ERROR_END_CODE;
        } finally {
            
            try {
                //
                if (outBuffer != null) {
                    outBuffer.flush();
                    outBuffer.close();
                }
                if (inBuffer != null) {
                    inBuffer.close();
                }
            } catch (IOException e) {
                //\郁bZ[W̐Aݒ
                BLogicMessages messages = new BLogicMessages();
                messages.add("fileUp.uploadingError",
                        new BLogicMessage("fileUp.uploadingError"));
                log.error(messages);
                return ERROR_END_CODE;
            }
            
            //ꎞ̈̃Abv[hf[^폜
            fileUp.destroy();
        }
        
        return NORMAL_END_CODE;
    }

    
    /**
     * WuX^[^ݒ肷
     * @param jobStarter
     */
    public void setJobStarter(JobStarter jobStarter) {
        this.jobStarter = jobStarter;
    }

}
