/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample000;

import java.util.Date;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.batch.functionsample.common.NyusyukkinData;

/**
 * T|[gNXB<br>
 * oe[ũf[^NAAVKf[^쐬B<br>
 * <ul>
 * <li>ID:1`WuReLXgɐݒ肵쐬ɐݒ</li>
 * <li>xXR[hF1`6_Őݒ</li>
 * <li>oR[hF0`1_Őݒ</li>
 * <li>R[hF0`3_Őݒ</li>
 * <li>ڋqR[h: 0000000001珇ɐݒ</li>
 * <li>zF1`1000000_Őݒ</li>
 * </ul>
 */
public class Sample000PreLogic implements SupportLogic<Sample000JobContext> {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(Sample000PreLogic.class);
        
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO;
    
    /**
     * NB
     */
    public BLogicResult execute(Sample000JobContext jobContext) {

    if(log.isDebugEnabled()){
        log.debug("start.");
    }
    
    //oe[ũf[^NA
    updateDAO.execute("SAMPLE000.deleteNyusyukkin", null);
     
    Random random = new Random();
    NyusyukkinData nyusyukkin = new NyusyukkinData();
    Date torihikibi = new Date(System.currentTimeMillis());
    
    int maxNumber = jobContext.getMaxNumber();
    for(int count = 1; count <= maxNumber; count++){
     
        int sitenCd = random.nextInt(6) + 1;
        int nyusyukkinCd = random.nextInt(2);
        int torihikiCd = random.nextInt(4);
        int kokyakuCd = count;
        int kingaku = random.nextInt(1000000) + 1;
        
        nyusyukkin.setId(count);
        nyusyukkin.setNyusyukkincd(nyusyukkinCd);
        nyusyukkin.setTorihikicd(torihikiCd);
        nyusyukkin.setSitencd(String.valueOf(sitenCd));
        nyusyukkin.setKokyakucd(String.format("%010d", kokyakuCd));
        nyusyukkin.setKingaku(kingaku);
        nyusyukkin.setTorihikibi(torihikibi);
        
        //f[^쐬
        updateDAO.execute("SAMPLE000.insertNyusyukkin", nyusyukkin);
    }

    if(log.isDebugEnabled()){
        log.debug("end.");
    }
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
    

}
