/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.LineReader;

public class LineFeed2LineReader
implements LineReader {
    private Reader reader = null;
    private String lineFeedChar = null;

    public LineFeed2LineReader(Reader reader, String lineFeedChar) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }
        if (lineFeedChar == null) {
            throw new IllegalArgumentException("lineFeedChar is required.");
        }
        if (lineFeedChar.length() != 2) {
            throw new IllegalArgumentException("lineFeedChar should be defined by 2 digit of character string.");
        }
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    public String readLine() {
        StringBuilder currentLineStringBuilder = new StringBuilder();
        char previousChar = '\u0000';
        char currentChar = '\u0000';
        char lineFeedChar1 = this.lineFeedChar.charAt(0);
        char lineFeedChar2 = this.lineFeedChar.charAt(1);
        int chr = 0;
        try {
            while ((chr = this.reader.read()) != -1) {
                currentChar = (char)chr;
                if (currentChar == lineFeedChar2 && previousChar == lineFeedChar1) {
                    currentLineStringBuilder.delete(currentLineStringBuilder.length() - 1, currentLineStringBuilder.length());
                    break;
                }
                previousChar = currentChar;
                currentLineStringBuilder.append(currentChar);
            }
        }
        catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }
        return currentLineStringBuilder.toString();
    }
}

