/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.dao.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateExecutor;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdateSupportImpl
implements BatchUpdateSupport {
    private static final TLogger LOGGER = TLogger.getLogger(BatchUpdateExecutor.class);
    protected UpdateDAO updateDAO = null;
    protected volatile Comparator<String> comparator = null;
    protected final Map<String, Queue<SqlHolder>> batchSqlsMap = new LinkedHashMap<String, Queue<SqlHolder>>();
    protected volatile boolean sortMode = false;
    protected volatile AtomicLong count = new AtomicLong(0L);
    private String[] sqlIdOrder = null;

    public BatchUpdateSupportImpl() {
    }

    public BatchUpdateSupportImpl(UpdateDAO updateDAO) {
        this(updateDAO, (Comparator<String>)null);
    }

    public BatchUpdateSupportImpl(UpdateDAO updateDAO, Comparator<String> comparator) {
        this.updateDAO = updateDAO;
        this.comparator = comparator;
        if (this.updateDAO == null) {
            LOGGER.warn("WAL036002");
        }
    }

    public BatchUpdateSupportImpl(UpdateDAO updateDAO, String ... sqlIdOrder) {
        this.updateDAO = updateDAO;
        this.sqlIdOrder = sqlIdOrder;
        if (this.updateDAO == null) {
            LOGGER.warn("WAL036002");
        }
    }

    @Override
    public void addBatch(String sqlID, Object bindParams) {
        if (sqlID == null || sqlID.length() == 0) {
            LOGGER.warn("WAL036003");
            return;
        }
        Queue<SqlHolder> sqlQueue = this.batchSqlsMap.get(sqlID);
        if (sqlQueue == null && (sqlQueue = this.batchSqlsMap.get(sqlID)) == null) {
            sqlQueue = new ConcurrentLinkedQueue<SqlHolder>();
            this.batchSqlsMap.put(sqlID, sqlQueue);
        }
        if (sqlQueue != null) {
            sqlQueue.add(new SqlHolder(sqlID, bindParams));
            this.count.incrementAndGet();
        }
    }

    @Override
    public int executeBatch() {
        return this.executeBatch(this.updateDAO, this.comparator, this.sqlIdOrder);
    }

    @Override
    public int executeBatch(UpdateDAO updateDAO) {
        return this.executeBatch(updateDAO, this.comparator, this.sqlIdOrder);
    }

    @Override
    public int executeBatch(UpdateDAO updateDAO, Comparator<String> comparator) {
        return this.executeBatch(updateDAO, comparator, null);
    }

    @Override
    public int executeBatch(UpdateDAO updateDAO, String ... sqlIdOrder) {
        return this.executeBatch(updateDAO, (Comparator<String>)null, sqlIdOrder);
    }

    protected int executeBatch(UpdateDAO updateDAO, Comparator<String> comparator, String[] sqlIdOrder) {
        int result = -1000;
        if (updateDAO == null) {
            LOGGER.warn("WAL036002");
            return -100;
        }
        ArrayList sqlHolderList = new ArrayList();
        List<String> keyList = new ArrayList<String>(this.batchSqlsMap.keySet());
        if (sqlIdOrder != null) {
            List<String> sqlIdOrderList = Arrays.asList(sqlIdOrder);
            if (keyList.size() > sqlIdOrderList.size()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("WAL036004", new Object[]{keyList.size(), sqlIdOrderList.size()});
                }
                return -200;
            }
            for (String key : keyList) {
                if (sqlIdOrderList.contains(key)) continue;
                LOGGER.warn("WAL036005", new Object[]{key});
                return -200;
            }
            keyList = sqlIdOrderList;
        } else if (this.sortMode || comparator != null) {
            if (comparator != null) {
                Collections.sort(keyList, comparator);
            } else {
                Collections.sort(keyList);
            }
        }
        for (String key : keyList) {
            if (!this.batchSqlsMap.containsKey(key)) continue;
            sqlHolderList.addAll(this.batchSqlsMap.get(key));
        }
        result = updateDAO.executeBatch(sqlHolderList);
        this.batchSqlsMap.clear();
        this.count.set(0L);
        this.sortMode = false;
        return result;
    }

    @Override
    public void sort() {
        this.sortMode = true;
    }

    @Override
    public void sort(Comparator<String> comparator) {
        this.sortMode = true;
        this.comparator = comparator;
    }

    @Override
    public void clear() {
        this.batchSqlsMap.clear();
        this.count.set(0L);
        this.sortMode = false;
    }

    @Override
    public long size() {
        return this.count.get();
    }

    @Override
    public List<SqlHolder> getSqlHolderList() {
        return this.getSqlHolderList(this.comparator);
    }

    @Override
    public List<SqlHolder> getSqlHolderList(Comparator<String> comparator) {
        return this.getSqlHolderList(comparator, null);
    }

    @Override
    public List<SqlHolder> getSqlHolderList(String ... sqlIdOrder) {
        return this.getSqlHolderList((Comparator<String>)null, sqlIdOrder);
    }

    protected List<SqlHolder> getSqlHolderList(Comparator<String> comparator, String[] sqlIdOrder) {
        ArrayList<SqlHolder> sqlHolderList = new ArrayList<SqlHolder>();
        List<String> keyList = new ArrayList<String>(this.batchSqlsMap.keySet());
        if (sqlIdOrder != null) {
            List<String> sqlIdOrderList = Arrays.asList(sqlIdOrder);
            if (keyList.size() > sqlIdOrderList.size()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("WAL036004", new Object[]{keyList.size(), sqlIdOrderList.size()});
                }
                return null;
            }
            for (String key : keyList) {
                if (sqlIdOrderList.contains(key)) continue;
                LOGGER.warn("WAL036005", new Object[]{key});
                return null;
            }
            keyList = sqlIdOrderList;
        } else if (this.sortMode || comparator != null) {
            if (comparator != null) {
                Collections.sort(keyList, comparator);
            } else {
                Collections.sort(keyList);
            }
        }
        for (String key : keyList) {
            if (!this.batchSqlsMap.containsKey(key)) continue;
            sqlHolderList.addAll((Collection<SqlHolder>)this.batchSqlsMap.get(key));
        }
        this.sortMode = false;
        return sqlHolderList;
    }
}

