/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.annotation.util;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.generic.GenericBeanFactoryAccessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanFactoryAccessorEx
extends GenericBeanFactoryAccessor {
    public GenericBeanFactoryAccessorEx(ListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        String[] beanNames;
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)this.getBeanFactory())) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBeanFactory().getBean(beanName));
        }
        return results;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        AbstractBeanDefinition abd;
        ConfigurableBeanFactory cbf;
        BeanDefinition bd;
        Object object = this.getBeanFactory().getBean(beanName);
        Class<?> handlerType = null;
        handlerType = AopUtils.isAopProxy((Object)object) ? AopUtils.getTargetClass((Object)object) : object.getClass();
        Annotation ann = AnnotationUtils.findAnnotation(handlerType, annotationType);
        if (ann == null && this.getBeanFactory() instanceof ConfigurableBeanFactory && this.getBeanFactory().containsBeanDefinition(beanName) && (bd = (cbf = (ConfigurableBeanFactory)this.getBeanFactory()).getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            Class beanClass = abd.getBeanClass();
            ann = AnnotationUtils.findAnnotation((Class)beanClass, annotationType);
        }
        return (A)ann;
    }
}

