/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationUtil {
    protected ValidationUtil() {
    }

    public static Errors validate(Validator validator, Object value) {
        String objectName = null;
        BindException errors = null;
        if (value != null && (objectName = value.getClass().getSimpleName()) != null) {
            objectName = Introspector.decapitalize(objectName);
        }
        errors = new BindException(value, objectName);
        if (validator != null) {
            validator.validate(value, (Errors)errors);
        }
        return errors;
    }

    public static List<FieldError> getFieldErrorList(Errors errors) {
        ArrayList<FieldError> resultList = new ArrayList<FieldError>();
        List errs = errors.getAllErrors();
        for (Object errObj : errs) {
            if (!(errObj instanceof FieldError)) continue;
            FieldError fe = (FieldError)errObj;
            resultList.add(fe);
        }
        return resultList;
    }

    public static List<ObjectError> getObjectErrorList(Errors errors) {
        ArrayList<ObjectError> resultList = new ArrayList<ObjectError>();
        List errs = errors.getAllErrors();
        for (Object errObj : errs) {
            if (!(errObj instanceof ObjectError)) continue;
            ObjectError oe = (ObjectError)errObj;
            resultList.add(oe);
        }
        return resultList;
    }

    public static List<DefaultMessageSourceResolvable> getDefaultMessageSourceResolvableList(Errors errors) {
        ArrayList<DefaultMessageSourceResolvable> resultList = new ArrayList<DefaultMessageSourceResolvable>();
        List errs = errors.getAllErrors();
        for (Object errObj : errs) {
            if (!(errObj instanceof DefaultMessageSourceResolvable)) continue;
            DefaultMessageSourceResolvable dmsr = (DefaultMessageSourceResolvable)errObj;
            resultList.add(dmsr);
        }
        return resultList;
    }
}

