/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.blogic;

import java.sql.SQLException;
import java.util.Map;

import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.constants.LogId;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.logger.TLogger;

import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/**
 * gUNVǗsrWlXWbNۃNXB<br>
 * <br>
 * t[[NŃgUNVǗsꍇA̒ۃNXpAAbstractTransactionBLogic#doMain\bhărWlXWbN쐬B<br>
 * ̒ۃNXprWlXWbÑgUNV̐U͈ȉ̒ʂłB
 * <ol>
 * <li>rWlXWbNJnꂽAgUNVJnB</li>
 * <li>sOX[ꂽAgUNVJn܂Ń[obNB</li>
 * <li>rWlXWbNIAR~bgAgUNVIB</li>
 * </ol>
 * @see jp.terasoluna.fw.batch.blogic.BLogic
 * @see jp.terasoluna.fw.batch.blogic.AbstractBLogic
 */
public abstract class AbstractTransactionBLogic extends AbstractBLogic {

    /**
     * vZXIR[hiُj
     */
    private static final int PROCESS_END_STATUS_FAILURE = 255;

    /**
     * O.
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(AbstractTransactionBLogic.class);

    /**
     * transactionManagerMap.
     */
    private Map<?, ?> transactionManagerMap = null;

    /**
     * transactionStatusMap
     */
    private Map<String, TransactionStatus> transactionStatusMap = null;

    /**
     * ob`s\bh.
     * @see jp.terasoluna.fw.batch.blogic.BLogic#execute(java.lang.String[], com.ibatis.sqlmap.client.SqlMapClient)
     */
    public int execute(BLogicParam param) {
        int status = PROCESS_END_STATUS_FAILURE;
        ApplicationContext ctx = getApplicationContext();

        this.transactionManagerMap = ctx
                .getBeansOfType(PlatformTransactionManager.class);

        // gUNVJn
        this.transactionStatusMap = startTransactions(this.transactionManagerMap);

        try {
            // 又
            status = doMain(param);

            // gUNVR~bg
            commitTransactions(this.transactionManagerMap,
                    this.transactionStatusMap);
        } catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException) e;
            }
            throw new BatchException(e);
        } finally {
            // gUNVIiR~bg[obNj
            boolean et = endTransactions(this.transactionManagerMap,
                    this.transactionStatusMap);
            if (!et) {
                LOGGER.error(LogId.EAL025001);
            }
        }

        return status;
    }

    /**
     * 又.
     * @param param
     * @return
     * @throws SQLException
     */
    public abstract int doMain(BLogicParam param);

    /**
     * gUNVJn.
     * @param trnMngMap PlatformTransactionManager}bv
     * @return TransactionStatus}bv
     */
    private Map<String, TransactionStatus> startTransactions(Map<?, ?> trnMngMap) {
        return BatchUtil.startTransactions(
                BatchUtil.getTransactionDefinition(), trnMngMap, LOGGER);
    }

    /**
     * gUNVR~bg.
     * @param trnMngMap PlatformTransactionManager}bv
     * @param tranStatMap TransactionStatus}bv
     */
    private void commitTransactions(Map<?, ?> trnMngMap,
            Map<String, TransactionStatus> tranStatMap) {
        BatchUtil.commitTransactions(trnMngMap, tranStatMap, LOGGER);
    }

    /**
     * gUNVIiR~bg[obNj.
     * @param trnMngMap PlatformTransactionManager}bv
     * @param tranStatMap TransactionStatus}bv
     * @return Ȃtrue
     */
    private boolean endTransactions(Map<?, ?> trnMngMap,
            Map<String, TransactionStatus> tranStatMap) {
        return BatchUtil.endTransactions(trnMngMap, tranStatMap, LOGGER);
    }
}
