/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.dao.support;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;

/**
 * ob`XVꊇsNX<br>
 */
public class BatchUpdateExecutor {
    /**
     * K[.
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(BatchUpdateExecutor.class);

    /**
     * ob`XVꊇs.<br>
     * <p>
     * IuWFNgBatchUpdateSupporttB[hTāAׂẴob`XVsB<br>
     * </p>
     * @param value Object TIuWFNg
     * @param updateDAO UpdateDAO sɎgpUpdateDAO
     * @return executeBatch̎sʃXg
     */
    public static List<BatchUpdateResult> executeBatch(Object value,
            UpdateDAO updateDAO) {
        List<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();

        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                BatchUpdateSupport bus = (BatchUpdateSupport) value;
                // 1s
                int res = 0;
                try {
                    res = bus.executeBatch(updateDAO);
                    resultList.add(new BatchUpdateResult(bus, Integer
                            .valueOf(res)));
                } catch (Throwable e) {
                    // Oi[
                    resultList.add(new BatchUpdateResult(bus, e));
                }
            } else if (value instanceof List) {
                // XgT
                List<?> valueList = (List<?>) value;

                for (Object obj : valueList) {
                    List<BatchUpdateResult> res = executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else if (value.getClass().isArray()) {
                // zT
                Object[] valueArray = (Object[]) value;

                for (Object obj : valueArray) {
                    List<BatchUpdateResult> res = executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else {
                // IuWFNgT
                List<BatchUpdateResult> res = executeBatchInnerObject(value,
                        updateDAO);
                resultList.addAll(res);
            }
        }

        return resultList;
    }

    /**
     * IuWFNgɑ΂ob`XVꊇsiĂяopj.<br>
     * @param value Object TIuWFNg
     * @param updateDAO UpdateDAO sɎgpUpdateDAO
     * @return executeBatch̎sʃXg
     */
    protected static List<BatchUpdateResult> executeBatchInnerObject(
            Object value, UpdateDAO updateDAO) {

        List<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();

        if (value != null) {
            BeanInfo bi = null;

            try {
                bi = Introspector.getBeanInfo(value.getClass());

                if (bi != null) {
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();

                    for (PropertyDescriptor pd : pds) {
                        if (pd != null) {
                            Class<?> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();

                            if (rm != null && isTargetClass(pt)) {
                                try {
                                    Object readValue = rm.invoke(value);
                                    List<BatchUpdateResult> res = executeBatch(
                                            readValue, updateDAO);
                                    resultList.addAll(res);
                                } catch (IllegalArgumentException e) {
                                    outputExceptionLog(e);
                                } catch (IllegalAccessException e) {
                                    outputExceptionLog(e);
                                } catch (InvocationTargetException e) {
                                    outputExceptionLog(e);
                                }
                            }
                        }
                    }
                }
            } catch (IntrospectionException e) {
                outputExceptionLog(e);
            }

        }

        return resultList;
    }

    /**
     * ob`XVXgNA.<br>
     * <p>
     * IuWFNgBatchUpdateSupporttB[hTāAׂẴob`XVNAB<br>
     * </p>
     * @param value Object TIuWFNg
     */
    public static void clearAll(Object value) {
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                // NA
                ((BatchUpdateSupport) value).clear();
            } else if (value instanceof List) {
                // XgT
                List<?> valueList = (List<?>) value;

                for (Object obj : valueList) {
                    clearAll(obj);
                }
            } else if (value.getClass().isArray()) {
                // zT
                Object[] valueArray = (Object[]) value;

                for (Object obj : valueArray) {
                    clearAll(obj);
                }
            } else {
                // IuWFNgT
                clearAllInnerObject(value);
            }
        }

        return;
    }

    /**
     * IuWFNgɑ΂ob`XVXgNAiĂяopj.<br>
     * @param value Object TIuWFNg
     */
    protected static void clearAllInnerObject(Object value) {

        if (value != null) {
            BeanInfo bi = null;

            try {
                bi = Introspector.getBeanInfo(value.getClass());

                if (bi != null) {
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();

                    for (PropertyDescriptor pd : pds) {
                        if (pd != null) {
                            Class<?> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();

                            if (rm != null && isTargetClass(pt)) {
                                try {
                                    Object readValue = rm.invoke(value);
                                    clearAll(readValue);
                                } catch (IllegalArgumentException e) {
                                    outputExceptionLog(e);
                                } catch (IllegalAccessException e) {
                                    outputExceptionLog(e);
                                } catch (InvocationTargetException e) {
                                    outputExceptionLog(e);
                                }
                            }
                        }
                    }
                }
            } catch (IntrospectionException e) {
                outputExceptionLog(e);
            }

        }

        return;
    }

    /**
     * ΏۃNXł邩肷B<br>
     * @param clazz NX^
     * @return true:Ώ / false:ΏۊONX
     */
    protected static boolean isTargetClass(Class<?> clazz) {
        if (clazz != null && clazz != Object.class && clazz != Class.class
                && !(Date.class.isAssignableFrom(clazz))
                && !(clazz.isPrimitive()) && !(isPrimitiveWrapper(clazz))) {
            return true;
        }
        return false;
    }

    /**
     * v~eBũbp[NX𔻒肷.<br>
     * @param pt Class&lt;?&gt;
     * @return true:v~eBũbp[NXł / false:v~eBũbp[NXł͂Ȃ
     */
    protected static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (clazz != null) {
            if (Number.class.isAssignableFrom(clazz)
                    && !AtomicInteger.class.isAssignableFrom(clazz)
                    && !AtomicLong.class.isAssignableFrom(clazz)
                    && !AtomicBoolean.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.class == clazz || Character.class == clazz
                    || String.class == clazz || Date.class == clazz
                    || Void.class == clazz) {
                return true;
            }
        }
        return false;
    }

    /**
     * OOo͂B
     * @param e Throwable
     */
    protected static void outputExceptionLog(Throwable e) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(LogId.WAL036001, e, (e.getMessage() == null ? "" : e
                    .getMessage()));
        }
    }

}
