/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * FileControlC^tF[XNX.
 * <p>
 * ̃NX́At@C쏈sFileUtilityNXbvĂB<br>
 * FileControlNXDIReiɂărWlXWbN𐶐ہArWlXWbN̑ƂĐݒ肷B<br>
 * FileControlNX͑ɁAt@CsۂɊƂȂpX(pX)B<br>
 * FileUtilityNX͈ȉ̋@\ĂB
 * <ul>
 * <li>t@C̕ύXt@C̈ړ</li>
 * <li>t@C̃Rs[</li>
 * <li>t@C̍폜</li>
 * <li>t@Č</li>
 * </ul>
 * ȂAt@C@\ŎgppX͑΃pXA΃pX̗wB
 * </p>
 * @see FileUtility
 */
public class FileControlImpl implements FileControl {

    /**
     * pX.
     * <p>
     * pXgp邱ƂɂAt@CANZXɔt@CpX̊ˑ̖邱ƂłB
     * </p>
     */
    private String basePath = "";

    /**
     * t@C̃Rs[B
     * @param srcFile Rs[̃t@C̃pX
     * @param newFile Rs[̃t@C̃pX
     */
    public void copyFile(String srcFile, String newFile) {

        FileUtility
                .copyFile(getAbsolutePath(srcFile), getAbsolutePath(newFile));
    }

    /**
     * t@C̍폜B
     * @param srcFile 폜t@C̃pX
     */
    public void deleteFile(String srcFile) {

        FileUtility.deleteFile(getAbsolutePath(srcFile));
    }

    /**
     * t@CB
     * @param fileList t@C̃Xg
     * @param newFile Ăłt@C̃pX
     */
    public void mergeFile(List<String> fileList, String newFile) {

        List<String> srcFileList = new ArrayList<String>();
        for (String fileName : fileList) {
            srcFileList.add(getAbsolutePath(fileName));
        }

        FileUtility.mergeFile(srcFileList, getAbsolutePath(newFile));
    }

    /**
     * t@C̕ύXt@C̈ړB
     * @param srcFile ړÕpX
     * @param newFile ړ̃pX
     */
    public void renameFile(String srcFile, String newFile) {

        FileUtility.renameFile(getAbsolutePath(srcFile),
                getAbsolutePath(newFile));
    }

    /**
     * FileControlŎgpt@C΃pXǂmFāA΃pXԋpB
     * @param fileName e\bḧƂĎ󂯂t@C
     * @return fileName̐΃pX
     * @throws t@C@\O
     */
    private String getAbsolutePath(String fileName) {

        if (fileName == null) {
            throw new FileException("File name is not set.", fileName);
        }

        File newFileObject = new File(fileName);

        if (!newFileObject.isAbsolute()) {
            StringBuilder newFilePath = new StringBuilder(basePath);
            return newFilePath.append(fileName).toString();
        } else {
            return fileName;
        }
    }

    /**
     * pX擾B
     * @return pX
     */
    public String getBasePath() {
        return basePath;
    }

    /**
     * pXݒ肷B
     * @param basePath pX
     */
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    /**
     * FileUtilitỹt@C̏㏑tOݒ肷B
     * @param checkFileExist ㏑tO
     */
    public void setCheckFileExist(boolean checkFileExist) {
        FileUtility.setCheckFileExist(checkFileExist);
    }

}
