/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;
import org.castor.util.Configuration;

public final class CacheFactoryRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$cache$CacheFactoryRegistry == null ? (class$org$castor$cache$CacheFactoryRegistry = CacheFactoryRegistry.class$("org.castor.cache.CacheFactoryRegistry")) : class$org$castor$cache$CacheFactoryRegistry));
    private static final String PROXY_CLASSNAME = (class$org$castor$cache$DebuggingCacheProxy == null ? (class$org$castor$cache$DebuggingCacheProxy = CacheFactoryRegistry.class$("org.castor.cache.DebuggingCacheProxy")) : class$org$castor$cache$DebuggingCacheProxy).getName();
    private Hashtable _cacheFactories = new Hashtable();
    static /* synthetic */ Class class$org$castor$cache$CacheFactoryRegistry;
    static /* synthetic */ Class class$org$castor$cache$DebuggingCacheProxy;
    static /* synthetic */ Class class$org$castor$cache$Cache;

    public CacheFactoryRegistry(Configuration config) {
        String prop = config.getProperty("org.castor.cache.Factories", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
        ClassLoader loader = (class$org$castor$cache$CacheFactoryRegistry == null ? (class$org$castor$cache$CacheFactoryRegistry = CacheFactoryRegistry.class$("org.castor.cache.CacheFactoryRegistry")) : class$org$castor$cache$CacheFactoryRegistry).getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                Class<?> cls = loader.loadClass(classname);
                Object obj = cls.newInstance();
                CacheFactory factory = (CacheFactory)obj;
                this._cacheFactories.put(factory.getCacheType(), factory);
            }
            catch (Exception ex) {
                LOG.error((Object)("Problem instantiating cache implementation: " + classname), (Throwable)ex);
            }
        }
    }

    public Cache getCache(Properties props, ClassLoader classLoader) throws CacheAcquireException {
        String cacheType = props.getProperty("type", "count-limited");
        CacheFactory cacheFactory = (CacheFactory)this._cacheFactories.get(cacheType);
        if (cacheFactory == null) {
            LOG.error((Object)("Unknown cache type '" + cacheType + "'"));
            throw new CacheAcquireException("Unknown cache type '" + cacheType + "'");
        }
        Cache cache = cacheFactory.getCache(classLoader);
        String prop = props.getProperty("debug", "false");
        boolean objectDebug = Boolean.valueOf(prop);
        boolean cacheDebug = LogFactory.getLog((Class)(class$org$castor$cache$Cache == null ? (class$org$castor$cache$Cache = CacheFactoryRegistry.class$("org.castor.cache.Cache")) : class$org$castor$cache$Cache)).isDebugEnabled();
        boolean cacheTypeDebug = LogFactory.getLog(cache.getClass()).isDebugEnabled();
        if (cacheTypeDebug || cacheDebug && objectDebug) {
            try {
                ClassLoader loader = (class$org$castor$cache$CacheFactoryRegistry == null ? (class$org$castor$cache$CacheFactoryRegistry = CacheFactoryRegistry.class$("org.castor.cache.CacheFactoryRegistry")) : class$org$castor$cache$CacheFactoryRegistry).getClassLoader();
                Class<?> cls = loader.loadClass(PROXY_CLASSNAME);
                Class[] types = new Class[]{class$org$castor$cache$Cache == null ? (class$org$castor$cache$Cache = CacheFactoryRegistry.class$("org.castor.cache.Cache")) : class$org$castor$cache$Cache};
                Object[] params = new Object[]{cache};
                cache = (Cache)cls.getConstructor(types).newInstance(params);
            }
            catch (Exception e) {
                String msg = "Error creating instance of: " + PROXY_CLASSNAME;
                LOG.error((Object)msg, (Throwable)e);
                throw new CacheAcquireException(msg, e);
            }
        }
        cache.initialize(props);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Successfully instantiated '" + cacheType + "' cache: " + props.get("name")));
        }
        return cache;
    }

    public Collection getCacheFactories() {
        return Collections.unmodifiableCollection(this._cacheFactories.values());
    }

    public Collection getCacheNames() {
        return Collections.unmodifiableCollection(this._cacheFactories.keySet());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

