/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.oxm.xsd.xerces;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.oxm.xsd.exception.NamespaceNotFoundException;
import jp.terasoluna.fw.oxm.xsd.exception.NamespaceNotUniqueException;
import jp.terasoluna.fw.oxm.xsd.exception.ParserIOException;
import jp.terasoluna.fw.oxm.xsd.exception.ParserNotSupportedException;
import jp.terasoluna.fw.oxm.xsd.exception.ParserSAXException;
import jp.terasoluna.fw.oxm.xsd.exception.PropertyIOException;
import jp.terasoluna.fw.oxm.xsd.exception.SchemaFileNotFoundException;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.fw.oxm.xsd.xerces.XML11ConfigurationEx;
import jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SchemaValidatorImpl
implements SchemaValidator {
    private static Log log = LogFactory.getLog(SchemaValidatorImpl.class);
    public static final String NESTED_PACKAGE_SEPARATOR = ".";
    public static final String NESTED_FOLDER_SEPARATOR = "/";
    public static final String XSD_FILE_SUFFIX = ".xsd";
    private static final String NAME_SPACE_SUFFIX = ".Namespace";
    protected String namespacePropertyFileName = "namespaces.properties";
    protected boolean cache = true;
    protected boolean namespace = false;
    protected XMLGrammarPool grammarPool = new XMLGrammarPoolImpl();
    protected Properties namespaceProperties = null;
    protected boolean namespaceCheck = true;

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setNamespace(boolean namespace) {
        this.namespace = namespace;
    }

    public void setNamespaceCheck(boolean namespaceCheck) {
        this.namespaceCheck = namespaceCheck;
    }

    public void setNamespaceProperties(Properties namespaceProperties) {
        this.namespaceProperties = namespaceProperties;
    }

    public void setNamespacePropertyFileName(String namespacePropertyFileName) {
        this.namespacePropertyFileName = namespacePropertyFileName;
    }

    public void initNamespaceProperties() {
        this.loadNamespaceProperties();
        if (this.namespaceCheck) {
            this.checkNamespaceProperties();
        }
    }

    protected void loadNamespaceProperties() {
        if (this.namespacePropertyFileName == null || "".equals(this.namespacePropertyFileName)) {
            return;
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.namespacePropertyFileName);
        if (is == null && (is = this.getClass().getResourceAsStream(NESTED_FOLDER_SEPARATOR + this.namespacePropertyFileName)) == null) {
            log.warn((Object)("Can not find property-file [" + this.namespacePropertyFileName + "]"));
            return;
        }
        this.namespaceProperties = new Properties();
        try {
            this.namespaceProperties.load(is);
        }
        catch (IOException e) {
            log.error((Object)("Can not read property-file [" + this.namespacePropertyFileName));
            throw new PropertyIOException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to close inputStream.", (Throwable)e);
            }
        }
    }

    protected void checkNamespaceProperties() {
        StringBuilder logStr = new StringBuilder();
        if (this.namespaceProperties == null || this.namespaceProperties.isEmpty()) {
            return;
        }
        ArrayList<String> namespacePropertiesList = new ArrayList<String>();
        for (Object namespaceKey : this.namespaceProperties.keySet()) {
            String namespaceValue = this.namespaceProperties.getProperty((String)namespaceKey);
            if (namespacePropertiesList.contains(namespaceValue)) {
                logStr.setLength(0);
                logStr.append("Namespace name [");
                logStr.append(namespaceValue);
                logStr.append("] is not unique. ");
                logStr.append("Namespace must be unique. ");
                logStr.append("(key = [");
                logStr.append(namespaceKey);
                logStr.append("])");
                log.error((Object)logStr.toString());
                throw new NamespaceNotUniqueException();
            }
            namespacePropertiesList.add(namespaceValue);
        }
    }

    public Document validate(InputStream in, Object object, ErrorMessages errorMessages) {
        if (in == null) {
            log.error((Object)"InputStream is null.");
            throw new IllegalArgumentException("InputStream is null.");
        }
        if (errorMessages == null) {
            log.error((Object)"ErrorMessages is null.");
            throw new IllegalArgumentException("ErrorMessages is null.");
        }
        DOMParser parser = null;
        try {
            parser = this.createDomParser(object);
            this.setCommonParserProperty(parser, errorMessages);
            this.setCommonParserFeature(parser);
        }
        catch (SAXNotRecognizedException e) {
            log.error((Object)"Schema property error.", (Throwable)e);
            throw new ParserNotSupportedException(e);
        }
        catch (SAXNotSupportedException e) {
            log.error((Object)"Schema property error.", (Throwable)e);
            throw new ParserNotSupportedException(e);
        }
        try {
            parser.parse(new InputSource(in));
        }
        catch (SAXException e) {
            log.error((Object)"Schema parse error.", (Throwable)e);
            throw new ParserSAXException(e);
        }
        catch (IOException e) {
            log.error((Object)"Schema io error.", (Throwable)e);
            throw new ParserIOException(e);
        }
        if (errorMessages.hasErrorMessage()) {
            return null;
        }
        return parser.getDocument();
    }

    protected DOMParser createDomParser(Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        DOMParser parser = new DOMParser(this.createXmlParserConfiguration());
        URL schemaURL = this.getUrl(object);
        if (schemaURL == null) {
            log.error((Object)("Schema file is not found. Set schema file in [root-classpath]/" + this.getSchemaFilePath(object)));
            throw new SchemaFileNotFoundException();
        }
        if (this.namespace) {
            StringBuilder key = new StringBuilder();
            key.append("http://apache.org/xml/properties/");
            key.append("schema/external-schemaLocation");
            StringBuilder location = new StringBuilder();
            location.append(this.getNamespaceName(object));
            location.append(" ");
            location.append(schemaURL.toExternalForm());
            parser.setProperty(key.toString(), (Object)location.toString());
        } else {
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaURL.toExternalForm());
        }
        return parser;
    }

    protected XMLParserConfiguration createXmlParserConfiguration() {
        if (this.namespace && this.cache) {
            return new XML11ConfigurationEx(this.grammarPool);
        }
        return new XML11ConfigurationEx();
    }

    protected void setCommonParserProperty(DOMParser parser, ErrorMessages errorMessages) throws SAXNotRecognizedException, SAXNotSupportedException {
        parser.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)new XMLErrorReporterEx(errorMessages));
    }

    protected void setCommonParserFeature(DOMParser parser) throws SAXNotRecognizedException, SAXNotSupportedException {
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setFeature("http://apache.org/xml/features/validation/schema", true);
    }

    protected URL getUrl(Object object) {
        return Thread.currentThread().getContextClassLoader().getResource(this.getSchemaFilePath(object));
    }

    protected String getSchemaFilePath(Object object) {
        if (object == null) {
            log.error((Object)"Argument is null.");
            throw new IllegalArgumentException("Argument is null.");
        }
        StringBuilder retStr = new StringBuilder();
        retStr.append(object.getClass().getName().replace(NESTED_PACKAGE_SEPARATOR, NESTED_FOLDER_SEPARATOR));
        retStr.append(XSD_FILE_SUFFIX);
        return retStr.toString();
    }

    protected String getNamespaceName(Object object) {
        if (object == null) {
            log.error((Object)"Argument is null.");
            throw new IllegalArgumentException("Argument is null.");
        }
        if (!this.namespace) {
            return null;
        }
        if (this.namespaceProperties == null) {
            String message = "Namespace property is not set. Put " + this.namespacePropertyFileName + " file on your classpath, " + "and call SchemaValidatorImpl initNamespaceProperties() " + "after instanciate.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        StringBuilder namespaceKey = new StringBuilder(object.getClass().getName());
        namespaceKey.append(NAME_SPACE_SUFFIX);
        String namespaceName = this.namespaceProperties.getProperty(namespaceKey.toString());
        if (namespaceName == null) {
            log.error((Object)("Schema namespace is not found. Set namespace key - " + namespaceKey.toString() + " in " + this.namespacePropertyFileName + " file."));
            throw new NamespaceNotFoundException();
        }
        return namespaceName;
    }
}

