/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.bind;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessage;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.exception.XMLRequestIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.w3c.dom.Document;

public class XMLServletRequestDataBinder
extends ServletRequestDataBinder {
    private static Log log = LogFactory.getLog(XMLServletRequestDataBinder.class);
    private OXMapper oxmapper = null;
    private SchemaValidator schemaValidator = null;

    public XMLServletRequestDataBinder(Object target, OXMapper oxmapper, SchemaValidator schemaValidator, String objectName) {
        super(target, objectName);
        this.oxmapper = oxmapper;
        this.schemaValidator = schemaValidator;
    }

    public void bind(ServletRequest request) {
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            if (this.schemaValidator != null) {
                Document doc = this.validate((InputStream)in);
                if (this.getBindingResult().hasErrors()) {
                    return;
                }
                this.oxmapper.unmarshal(doc, this.getTarget());
            } else {
                this.oxmapper.unmarshal((InputStream)in, request.getCharacterEncoding(), this.getTarget());
            }
        }
        catch (IOException e) {
            log.error((Object)"Request stream error.", (Throwable)e);
            throw new XMLRequestIOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to close request stream.", (Throwable)e);
            }
        }
    }

    protected Document validate(InputStream in) {
        if (in == null) {
            log.error((Object)"InputStream is null.");
            throw new IllegalArgumentException("InputStream is null.");
        }
        ErrorMessages errorMessages = new ErrorMessages();
        Document doc = this.schemaValidator.validate(in, this.getTarget(), errorMessages);
        BindingResult errors = this.getBindingResult();
        for (ErrorMessage errorMessage : errorMessages.getErrorMessages()) {
            FieldError fe = new FieldError(this.getObjectName(), errorMessage.getField(), null, false, errors.resolveMessageCodes(errorMessage.getKey(), errorMessage.getField()), (Object[])this.createReplaceValues(errorMessage.getField(), errorMessage.getReplaceValues()), null);
            errors.addError((ObjectError)fe);
        }
        return doc;
    }

    protected String[] createReplaceValues(String field, String[] replaceValues) {
        if (field == null) {
            field = "";
        }
        if (replaceValues == null || replaceValues.length == 0) {
            return new String[]{field};
        }
        String[] resultReplaceValues = new String[replaceValues.length + 1];
        System.arraycopy(replaceValues, 0, resultReplaceValues, 0, replaceValues.length);
        resultReplaceValues[0] = field;
        resultReplaceValues[resultReplaceValues.length - 1] = replaceValues[0];
        return resultReplaceValues;
    }
}

