/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractFileDownloadView
extends AbstractView {
    private static Log log = LogFactory.getLog(AbstractFileDownloadView.class);
    protected int chunkSize = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"FileDownload start.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = this.getInputStream(model, request);
            }
            catch (IOException e) {
                log.error((Object)"FileDownload Failed.", (Throwable)e);
                throw e;
            }
            if (inputStream == null) {
                log.error((Object)"FileDownload Failed. InputStream is null.");
                throw new IOException("FileDownload Failed. InputStream is null.");
            }
            try {
                outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                log.error((Object)"FileDownload Failed.", (Throwable)e);
                throw e;
            }
            this.addResponseHeader(model, request, response);
            try {
                this.writeResponseStream(inputStream, outputStream);
            }
            catch (IOException e) {
                log.error((Object)"FileDownload Failed.", (Throwable)e);
                throw e;
            }
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                log.error((Object)"FileDownload Failed.", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Cannot close InputStream.", (Throwable)ioe);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Cannot close OutputStream.", (Throwable)ioe);
                }
            }
        }
    }

    protected abstract InputStream getInputStream(Map var1, HttpServletRequest var2) throws IOException;

    protected void writeResponseStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            return;
        }
        byte[] buffer = new byte[this.chunkSize];
        int length = 0;
        while ((length = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }
    }

    protected abstract void addResponseHeader(Map var1, HttpServletRequest var2, HttpServletResponse var3);
}

