/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.exceptionhandler.service;

import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.rich.exception.ServiceException;
import jp.terasoluna.rich.functionsample.common.ExceptionHandlerFilter;
import jp.terasoluna.rich.functionsample.exceptionhandler.bean.ExceptionData;
/**
 * OT[rX̎NX<br>
 * eǑ^ɂĐsB<br>
 * <li>systemException : ͂ꂽG[R[hƃNX𗘗păVXeO
 * 𐶐B</li>
 * <li>serviceException : ͂ꂽG[R[h𗘗păT[rXO
 * B</li>
 * <li>bindException: ͂ꂽG[^CvɂăoChO𐶐B</li>
 * <li>̑(exception) :͂ꂽNX𗘗pėO𐶐B</li><br>
 * <br>
 *  r[̗O͏ȂB
 *
 */
public class ExceptionHandlerServiceImpl implements
    ExceptionHandlerService<ExceptionData> {

    /**
     * O𔭐B<br>
     * r[Ȍꍇ͏sȂB
     *
     * @param params ONX
     * @throws Exception O
     */
    public void thorwException(ExceptionData params) throws Exception {

        String className = params.getClassName();
        String errorType = params.getErrorType();
        String errorCode = params.getErrorCode();
        boolean view = params.getView();
        
        //r[̗Oۂ`FbN
        if (!view) {
            try {
                if ("systemException".equalsIgnoreCase(errorType)) {
                    //VXeO
                    throw new SystemException(
                            (Exception) Class.forName(className).newInstance(),
                            errorCode);
                } else if ("serviceException".equalsIgnoreCase(errorType)) {
                    //T[rXO
                    throw new ServiceException(errorCode);
                } else if ("bindException".equalsIgnoreCase(errorType)) {
                    //oChO
                    BindException errors = new BindException(params, "params");
                    String[] codes = {"typeMismatch.boolean"};
                    String args1 = "XMLFormCheckInputData[0].boolean[0]";
                    String args2 = "boolean";
                    String args3 = "XXX";
                    Object[] arg = {args1, args2, args3};
                    FieldError fe = new FieldError(this.getClass().getName(), 
                            "XMLFormCheckInputData[0].boolean[0]", null, false, 
                            codes, arg, null);
                    errors.addError(fe);
                    throw errors;
                } else {
                    //̑O
                    throw (Exception) Class.forName(className).newInstance();
                }
            } catch (ClassNotFoundException e) {
                throw new SystemException(e,
                        ExceptionHandlerFilter.ERROR_CODE);
            } catch (IllegalAccessException e) {
                throw new SystemException(e,
                        ExceptionHandlerFilter.ERROR_CODE);
            } catch (InstantiationException e) {
                throw new SystemException(e,
                        ExceptionHandlerFilter.ERROR_CODE);
            } catch (ClassCastException e) {
                throw new SystemException(e,
                        ExceptionHandlerFilter.ERROR_CODE);
            }
        }
    }

}
