/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.formcheck.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.formcheck.bean.FormCheckResultData;
import jp.terasoluna.rich.functionsample.formcheck.bean.XMLFormCheckInputData;
import jp.terasoluna.rich.functionsample.formcheck.service.XMLFormCheckService;

/**
 * XML``FbÑRg[<br>
 * ``FbNƊ֌WȂȂ̂ŉ̏sȂB
 *
 */
public class XMLFormCheckController extends
        TerasolunaController<XMLFormCheckInputData, FormCheckResultData> {
    
    /**
     * T[rXNX
     */
    protected XMLFormCheckService xmlFormCheckService = null;
    

    /**
     * T[rXNXsB<br>
     * T[rXNX͌``FbNƊ֌WȂȂ̂ŉ̏sȂB
     *
     * @param command ̓f[^
     * @return ʃf[^
     * @throws Exception O
     */
    @Override
    protected FormCheckResultData executeService(
            XMLFormCheckInputData command) throws Exception {
        return xmlFormCheckService.succeed(command);
    }

    /**
     * T[rXNXݒ肷B
     * @param xmlFormCheckService T[rXNX
     */
    public void setXmlFormCheckService(XMLFormCheckService
            xmlFormCheckService) {
        this.xmlFormCheckService = xmlFormCheckService;
    }
}
