/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.requestanalysis.service;


import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.rich.functionsample.common.bean.StringBean;
import jp.terasoluna.rich.functionsample.requestanalysis.bean.RequestAnalysisData;
import jp.terasoluna.rich.functionsample.requestanalysis.exception.TypeCheckException;

/**
 * ͂ꂽf[^̃^Cv`FbNsT[rX̎NX
 *
 */
public class RequestAnalysisServiceImpl implements RequestAnalysisService {

    /**
     * G[bZ[W
     */
    private final String message =
        "{0}̃^Cv`FbNŃG[܂B";

    /**
     * NX
     */
    protected RequestContextSupport ctxSupport = null;

    /**
     * ͂ꂽf[^̃^Cv`FbNsB<br>
     * primaryType͐ݒ肪oȂꍇAnullł͂Ȃl̂
     * ^Cṽ`FbN͏oȂB<br>
     * ł̓NX^Cv`FbNsĂB
     *
     * @param command ͈NX
     * @throws TypeCheckException `FbNG[Lꍇ
     */
    public void checkInputDataType(RequestAnalysisData command) 
            throws TypeCheckException {
        
        if (!(command.getStringClass() instanceof String)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"stringClass"}));
        }
        if (!(command.getBooleanClass() instanceof Boolean)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"booleanClass"}));
        }
        if (!(command.getDoubleClass() instanceof Double)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"doubleClass"}));
        }
        if (!(command.getCharacterClass() instanceof Character)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"characterClass"}));
        }
        if (!(command.getFloatClass() instanceof Float)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"floatClass"}));
        }
        if (!(command.getIntegerClass() instanceof Integer)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"integerClass"}));
        }
        if (!(command.getLongClass() instanceof Long)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"longClass"}));
        }
        if (!(command.getShortClass() instanceof Short)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"shortClass"}));
        }
        if (!(command.getByteClass() instanceof Byte)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"byteClass"}));
        }
        if (!(command.getDateClass() instanceof Date)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"dateClass"}));
        }
        if (!(command.getBigDecimalClass() instanceof BigDecimal)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"bigDecimalClass"}));
        }
        if (!(command.getArrayClass() instanceof String[])) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"arrayClass"}));
        }
        if (!(command.getBeanClass() instanceof StringBean)) {
            throw new TypeCheckException(
                MessageFormat.format(message, new Object[]{"beanClass"}));
        }
        if ("xmlRequestAnalysis".equals(ctxSupport.getRequestName())) {
            if (!(command.getArrayListClass() instanceof ArrayList)) {
                throw new TypeCheckException(
                    MessageFormat.format(message,
                            new Object[]{"arrayListClass"}));
            }
            if (!(command.getBeanArrayClass() instanceof StringBean[])) {
                throw new TypeCheckException(
                    MessageFormat.format(message,
                            new Object[]{"beanArrayClass"}));
            }
        }
    }
        
    /**
     * ctxSupportݒ肷B
     * @param ctxSupport ctxSupport
     */
    public void setCtxSupport(RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }

}
