/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.rich.exception.ForbiddenURIException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
/**
 * ĂURIȊOւ̃ANZX֎~tB^B
 *
 * <p>
 * ForbiddenURICheckerŋꂽURIȊO͊OANZXłȂ悤ɂB
 * </p>
 *
 * <p>ȉ̂悤 web.xmlɃtB^}bsO`sB</p>
 * 
 * <p>
 * yfvCgfBXNv^iweb.xmlj̐ݒz<br>
 * <code><pre>
 *   &lt;filter&gt;
 *     &lt;filter-name&gt;forbiddenURIFilter&lt;/filter-name&gt;
 *     &lt;filter-class&gt;jp.terasoluna.fw.web.rich.ForbiddenURIFilter&lt;/filter-class&gt;
 *   &lt;/filter&gt;
 *   &lt;filter-mapping&gt;
 *     &lt;filter-name&gt;forbiddenURIFilter&lt;/filter-name&gt;
 *     &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 *   &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * URĨ`FbN̂߁ADIReiForbiddenURIChecker擾B
 * 擾BeanID́hforbiddenURICheckerhƂB
 * ForbiddenURIChecker擾ۂɗpBeanIDJX^}CYꍇ́A
 * tB^̏p[^uhcheckerBeanIDhv
 * ForbiddenURIChecker擾邷邽߂BeanLq邱ƂŒڎw肷邱ƂłB
 * ʏ́AinitParamer̎w͕svłB
 * </p>
 * 
 * <p>
 * yinitParameter𗘗pfvCgfBXNv^iweb.xmlj̐ݒz<br>
 * <code><pre>
 *   &lt;filter&gt;
 *     &lt;filter-name&gt;forbiddenURIFilter&lt;/filter-name&gt;
 *     &lt;filter-class&gt;jp.terasoluna.fw.web.rich.ForbiddenURIFilter&lt;/filter-class&gt;
 *     &lt;init-param&gt;
 *       &lt;param-name&gt;checkerBeanID&lt;/param-name&gt;
 *       &lt;param-value&gt;newChecker&lt;/param-value&gt;
 *     &lt;/init-param&gt;
 *   &lt;/filter&gt;
 *   &lt;filter-mapping&gt;
 *     &lt;filter-name&gt;forbiddenURIFilter&lt;/filter-name&gt;
 *     &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 *   &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 *
 * <p>
 * NGXg URI
 * ANZXURIł͂Ȃꍇɂ́A
 * ForbiddenURIExceptionX[B
 * X[ꂽÓAT[ubgServlet񋟂ĂG[y[W̋@\𗘗p邱ƁB
 * SimpleMappingExceptionResolverExQƂ̂ƁB
 * </p>
 * 
 * <p>
 * yfvCgfBXNv^iweb.xmlj̐ݒz<br>
 * <code><pre>
 *   &lt;error-page&gt;
 *       &lt;exception-type&gt;jp.terasoluna.fw.web.rich.exception.ForbiddenURIException&lt;/exception-type&gt;
 *       &lt;location&gt;/error/forbidden-uri-error.jsp&lt;/location&gt;
 *   &lt;/error-page&gt;
 * @@ 炩ߌŒ̃G[dLq/error/forbidden-uri-error.jsppӂĂƁB
 * </pre></code>
 * </p>
 *
 * <p>
 * sȃANZX}~tB^ł邽߁A
 * o邾^C~OōŏɎs悤ɐݒ肷邱Ƃ]܂B
 * </p>
 *
 */
public class ForbiddenURIFilter implements Filter {
    
    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ForbiddenURIFilter.class);
    
    /**
     * DIRei֎~URI`FbJ擾ۂBeanID̃ftHglB
     */
    private static final String DEFAULT_CHECKER_BEANID = 
        "forbiddenURIChecker";
    
    /**
     * p[^֎~URI`FbJBeanID擾邽߂̃L[B
     */
    private static final String INITPARAM_KEY_CHECKER_BEANID = 
        "checkerBeanID";

    /**
     * ֎~URI`FbJB
     */
    private ForbiddenURIChecker checker = null;

    /**
     * tB^̏sB
     * ֎~URI`FbJDIRei擾B
     * 
     * @param config tB^ݒ
     * @throws ServletException T[ubgO
     */
    public void init(FilterConfig config) throws ServletException {
        String checkerBeanID
            = config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID);
        if (checkerBeanID == null) {
            checkerBeanID = DEFAULT_CHECKER_BEANID;
        }
        // ReLXg̎擾
        ApplicationContext context 
            = WebApplicationContextUtils.getWebApplicationContext(
                config.getServletContext());
        try {
            this.checker = 
                (ForbiddenURIChecker) context.getBean(
                        checkerBeanID,
                        ForbiddenURIChecker.class);
        } catch (BeanNotOfRequiredTypeException e) {
            log.error("the bean is not of the required type"
                    + " - ForbiddenURIChecker.");
            throw e;
        } catch (NoSuchBeanDefinitionException e) {
            log.error("there's no such bean definition. BeanID="
                    + checkerBeanID + ".");
            throw e;
        } catch (BeansException e) {
            log.error("the bean could not be created. BeanID="
                    + checkerBeanID + ".");
            throw e;
        }
    }

    /**
     * tB^B ֎~ꂽURI`FbNB
     * 
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain `FCꂽtB^
     * @throws IOException o͗O
     * @throws ServletException T[ubgO
     */
    public void doFilter(
            ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {
        // Requestɐݒ肳ĂURI擾
        String requestURI =
            ((HttpServletRequest) req).getRequestURI().replaceFirst(
                    ((HttpServletRequest) req).getContextPath(), "");
        // ֎~ꂽURI`FbN
        if (!checker.isAllowedURI(requestURI)) {
            log.error("request url is forbidden!");
            // ֎~ĂURIOX[
            throw new ForbiddenURIException();
        }
        chain.doFilter(req, res);
    }

    /**
     * tB^̔jsB
     * ȂɂȂB
     */
    public void destroy() {
    }
}
