/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.common.taglib;



import java.util.Calendar;
import java.util.Date;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.taglib.html.Constants;
import org.apache.struts.taglib.html.SelectTag;

/**
 * N,,Option^Oo͂^ONXB
 * <br><code>selected="true"</code>ƂꍇAݔN{plusDay̔N
 * selectedw肷Option^Oo͂B
 * <br><code>selected="false"</code>ƂꍇAForm̔Nselectedw肷B
 * Formɏ񂪂Ȃꍇselectedw͂AݔNA1A1\邱
 * ɂȂB
 * <br>N,,̂ǂo͂邩́A<code>var ="day"</code>̂悤Ɏw肷B
 * iK{j
 * <br>ӁFZNg^O̒lQƂ邽߁Ahtml:select̓Ŏgp邱ƁB
 * <br>ӁF30܂ł̌A邤NvZ͍s킸AIɓς悤ȓ
 * ȂB
 * <br>gpF
 *<code>
 * <html:select property="checkinYear">
 *   <thz:currentDateOptions var ="year" selected="true" plusDay="1"/>
 * </html:select>N
 *
 * <html:select property="checkinMonth">
 *   <thz:currentDateOptions var ="month" selected="true" plusDay="1"/>
 * </html:select>
 * <html:select property="checkinDay" >
 *   <thz:currentDateOptions var ="day" selected="true" plusDay="1"/>
 * </html:select>
 *</code>
 *̔Nselectedw肳ZNg{bNXo͂B
 *
 * @version 1.0
 */
public class CurrentDateOptionsTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8856958350065973508L;

    //ǂ̃tB[ho͂邩Bmonth,day w肷BftHgmonthB
    private String var;

    //i߂
    private String plusDay;

    //selectedǉ邩ǂ
    private boolean selected = true;

    public void setVar(String var) {
        this.var = var;
    }

    public void setPlusDay(String plusDay) {
        this.plusDay = plusDay;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return wB <code>SKIP_BODY</code>
     * @throws JspException JSPO
     */
    public int doStartTag() throws JspException {

        //o͂镶
        StringBuffer result = new StringBuffer("");

        //selectedw肷t܂Ői߂
        int plus = 0;

        if (!"".equals(plusDay) && !(plusDay == null)) {
            plus = Integer.parseInt(plusDay);
        }

        Date date = new Date();

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        //i߂̓t擾
        calendar.add(Calendar.DATE, plus);
        
        if (var != null && !"".equals(var)) {
            
            //N̂ǂo͂邩
            //w̏ꍇ
            if (var.equals("month")) {

                //Calendar.MONTH0n܂邽߁A1ǉB
                calendar.add(Calendar.MONTH, 1);

                for (int i = 0; i < 12; i++) {
                    //Option^O(value)̏o
                    result.append("<option value= \"" + String.valueOf(i + 1)
                            + "\"");
                    //selectedw肳ĂꍇǍselectedt^
                    //w肳ĂȂꍇAtH[Ɠselectedt^
                    if ((selected && i + 1 == calendar.get(Calendar.MONTH))
                            || (!selected && this.selectTag().isMatched(
                                    String.valueOf(i + 1)))) {
                        //selected̏o
                        result.append(" selected=\"selected\"");
                    }
                    //Option^O({fB)̏óB
                    //HTMLo͂邽߁A^O͂ȂB
                    result.append(">");
                    result.append(String.valueOf(i + 1));
                }
                //w̏ꍇ
                } else if (var.equals("day")) {

                //w萔Ai߂
                for (int i = 0; i < 31; i++) {
                    result.append("<option value= \"" + String.valueOf(i + 1)
                            + "\"");
                    //selectedw肳ĂꍇA̓selectedt^
                    //w肳ĂȂꍇAtH[Ɠselectedt^
                    if ((selected && i + 1 == calendar.get(Calendar.DATE))
                            || (!selected && this.selectTag().isMatched(
                                    String.valueOf(i + 1)))) {
                        //selected̏o
                        result.append(" selected=\"selected\"");
                    }
                    //Option^O({fB)̏óB
                    //HTMLo͂邽߁A^O͂ȂB
                    result.append(">");
                    result.append(String.valueOf(i + 1));
                }
                //Nw̏ꍇ
                } else if (var.equals("year")){
                //Nw萔Ai߂
                for (int i = 0; i < 2; i++) {
                    result.append("<option value= \"" +
                            String.valueOf(i + calendar.get(Calendar.YEAR))
                            + "\"");
                    //selectedw肳ĂꍇA̔Nselectedt^
                    //w肳ĂȂꍇAtH[ƓNselectedt^
                    if ((selected && i + calendar.get(Calendar.YEAR) ==
                        calendar.get(Calendar.YEAR))||
                       (!selected && this.selectTag().isMatched(
                                    String.valueOf(i + calendar.
                                            get(Calendar.YEAR))))) {
                        //selected̏o
                        result.append(" selected=\"selected\"");
                    }
                    //Option^O({fB)̏óB
                    //HTMLo͂邽߁A^O͂ȂB
                    result.append(">");
                    result.append(String.valueOf(i + calendar.get(Calendar.YEAR)));
                }
            }
            
        }

        try {
            //^Ȍo
            pageContext.getOut().print(result.toString());
        } catch (Exception ex) {
            throw new JspException(ex);
        }
        //XLbv{fBԋp
        return SKIP_BODY;
    }

    //y[WReLXg̃ZNg^O̎QƂ擾郁\bh
    private SelectTag selectTag() throws JspException {
        SelectTag selectTag = (SelectTag) pageContext
                .getAttribute(Constants.SELECT_KEY);

        if (selectTag == null) {
            throw new JspException();
        }

        return selectTag;
    }
}