/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.jndi.service;

import java.util.Map;

import jp.terasoluna.fw.web.jndi.JndiSupport;

/**
 * JNDI\[XT[rX
 *
 */
public class ListJndiInitializeServiceImpl implements ListJndiInitializeService {
    /**
     * JNDIT|[gNX
     */
    protected JndiSupport jndiSupport = null;
    /**
     * JNDIXg擾T[rX
     */
    protected ListJndiService listJndiService = null;
    /**
     * listJndiService擾B
     * @return listJndiService
     */
    public ListJndiService getListJndiService() {
        return listJndiService;
    }

    /**
     * listJndiServiceݒ肷B
     * @param listJndiService listJndiServiceB
     */
    public void setListJndiService(ListJndiService listJndiService) {
        this.listJndiService = listJndiService;
    }

    /**
     * jndiSupport擾B
     * @return jndiSupport
     */
    public JndiSupport getJndiSupport() {
        return jndiSupport;
    }

    /**
     * jndiSupportݒ肷B
     * @param jndiSupport jndiSupportB
     */
    public void setJndiSupport(JndiSupport jndiSupport) {
        this.jndiSupport = jndiSupport;
    }
    
    /**
     * JNDI\[XB
     *
     * @return JNDIXg
     */
    public Map<String, Object> jndiListInitialize(){
        Map<String, Object> retMap = null;
         
        // JNDI\[Xݒ肷B
        // rebindŔJndiException̓Lb`B
        jndiSupport.rebind("value1","param1");
        jndiSupport.rebind("value2","param2");
        jndiSupport.rebind("value3","param3");
        
        retMap = listJndiService.getListJndi();
        return retMap;
    }
}