/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.common.web.action;

import jp.terasoluna.thin.functionsample.common.FunctionUVO;
import jp.terasoluna.thin.functionsample.common.bean.LogonParam;
import jp.terasoluna.thin.functionsample.common.service.LogonService;
import jp.terasoluna.thin.functionsample.serverblockage.web.ServerBlockageController;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.fw.web.thin.ServerBlockageControlFilter;

/**
 * T[oǂJANV
 *
 * @version 2006/03/07
 */
public class CancelServerBlockageAction 
                    extends AbstractBLogicAction<LogonParam> {
    /**
     * OCT[rX
     */
    private LogonService logonService = null;
    /**
     * OC΁AT[oǂJB 
     *
     * @param param [UID,pX[hۑĂp[^NX
     * @return BLogicResult
     * @throws Exception
     */
    @Override
    public BLogicResult doExecuteBLogic(LogonParam param) 
                                                throws Exception {
//      ʂi[邽߂̃IuWFNg
    	BLogicResult result = new BLogicResult();

        // F؏
        FunctionUVO uvo = logonService.logon(param);
        
        if (uvo == null) {
            // [U񂪎擾łȂꍇiF؎sj̏
            result.setResultString("failure");
        } else {
            // Rg[擾
            ServerBlockageController controller
                = (ServerBlockageController) 
                    ServerBlockageControlFilter.getServerBlockageController();
            // T[oǂB
            controller.open();
            result.setResultString("success");
        }

        return result;
    }
    /**
     * logonService擾B
     * @return logonService
     */
    public LogonService getLogonService() {
        return logonService;
    }
    /**
     * logonServiceݒ肷B
     * @param logonService logonServiceB
     */
    public void setLogonService(LogonService logonService) {
        this.logonService = logonService;
    }

}
