/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLStatementMatcher {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;

    public SQLStatementMatcher(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public SQLStatementMatcher(boolean bl, boolean bl2, boolean bl3) {
        this.caseSensitive = bl;
        this.exactMatch = bl2;
        this.useRegularExpressions = bl3;
    }

    public List getMatchingObjects(Map map, String string, boolean bl, boolean bl2) {
        if (null == string) {
            string = "";
        }
        Iterator iterator = map.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string2;
            String string3;
            String string4 = (String)iterator.next();
            if (bl2) {
                string3 = string;
                string2 = string4;
            } else {
                string3 = string4;
                string2 = string;
            }
            if (!this.doStringsMatch(string3, string2)) continue;
            Object v = map.get(string4);
            if (bl && v instanceof Collection) {
                arrayList.addAll((Collection)v);
                continue;
            }
            arrayList.add(map.get(string4));
        }
        return arrayList;
    }

    public boolean contains(Collection collection, String string, boolean bl) {
        for (String string2 : collection) {
            String string3;
            String string4;
            if (bl) {
                string4 = string;
                string3 = string2;
            } else {
                string4 = string2;
                string3 = string;
            }
            if (!this.doStringsMatch(string4, string3)) continue;
            return true;
        }
        return false;
    }

    public boolean doStringsMatch(String string, String string2) {
        if (null == string) {
            string = "";
        }
        if (null == string2) {
            string2 = "";
        }
        if (this.useRegularExpressions && !this.exactMatch) {
            return this.doPerl5Match(string, string2);
        }
        return this.doSimpleMatch(string, string2);
    }

    private boolean doSimpleMatch(String string, String string2) {
        if (this.exactMatch) {
            return StringUtil.matchesExact(string, string2, this.caseSensitive);
        }
        return StringUtil.matchesContains(string, string2, this.caseSensitive);
    }

    private boolean doPerl5Match(String string, String string2) {
        return StringUtil.matchesPerl5(string, string2, this.caseSensitive);
    }
}

