/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.StreamMessage;

public class MockMessageProducer
implements MessageProducer,
Serializable {
    private MockConnection connection;
    private MockDestination destination;
    private MockSession session;
    private boolean closed;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    private int deliveryMode;
    private int priority;
    private long timeToLive;

    public MockMessageProducer(MockConnection mockConnection, MockSession mockSession, MockDestination mockDestination) {
        this.connection = mockConnection;
        this.destination = mockDestination;
        this.session = mockSession;
        this.closed = false;
        this.disableMessageId = false;
        this.disableTimestamp = false;
        this.deliveryMode = 2;
        this.priority = 4;
        this.timeToLive = 0L;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        this.send(this.destination, message, n, n2, l);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        this.connection.throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Producer is closed");
        }
        if (null == destination) {
            throw new InvalidDestinationException("destination must not be null");
        }
        if (message instanceof MockMessage && this.connection.getConfigurationManager().getDoCloneOnSend()) {
            message = (MockMessage)((MockMessage)message).clone();
        }
        if (destination instanceof MockQueue) {
            this.setJMSMessageHeaders(message, destination, n, n2, l);
            this.session.addSessionToQueue((MockQueue)destination);
            ((MockQueue)destination).addMessage(message);
        } else if (destination instanceof MockTopic) {
            this.setJMSMessageHeaders(message, destination, n, n2, l);
            this.session.addSessionToTopic((MockTopic)destination);
            ((MockTopic)destination).addMessage(message);
        } else {
            throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
        }
    }

    public Destination getDestination() throws JMSException {
        this.connection.throwJMSException();
        return this.destination;
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.connection.throwJMSException();
        this.disableMessageId = bl;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.connection.throwJMSException();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.connection.throwJMSException();
        this.disableTimestamp = bl;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.connection.throwJMSException();
        return this.disableTimestamp;
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.connection.throwJMSException();
        this.deliveryMode = n;
    }

    public int getDeliveryMode() throws JMSException {
        this.connection.throwJMSException();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        this.connection.throwJMSException();
        this.priority = n;
    }

    public int getPriority() throws JMSException {
        this.connection.throwJMSException();
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.connection.throwJMSException();
        this.timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.connection.throwJMSException();
        return this.timeToLive;
    }

    private void setJMSMessageHeaders(Message message, Destination destination, int n, int n2, long l) throws JMSException {
        message.setJMSDeliveryMode(n);
        message.setJMSPriority(n2);
        message.setJMSDestination(destination);
        long l2 = System.currentTimeMillis();
        if (!this.disableTimestamp) {
            message.setJMSTimestamp(l2);
        }
        if (0L == l) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(l2 + l);
        }
        if (!this.disableMessageId) {
            message.setJMSMessageID("ID:" + String.valueOf(Math.random()));
        }
        if (message instanceof MockMessage) {
            ((MockMessage)message).setReadOnly(true);
            ((MockMessage)message).setReadOnlyProperties(true);
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
        }
        if (message instanceof StreamMessage) {
            ((StreamMessage)message).reset();
        }
    }
}

