/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import jp.terasoluna.fw.ex.unit.exception.PopulationFailedException;
import jp.terasoluna.fw.ex.unit.util.DateConvertUtils;
import jp.terasoluna.fw.ex.unit.util.Populator;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPopulator<T>
implements Populator<T> {
    private String dateFormat = null;
    private static final List<String> defaultDateFormatList = Arrays.asList("yyyy-MM-dd", "yyyy/MM/dd", "HH:mm:ss");
    private boolean ignoreParseException = true;

    public void setIgnoreParseException(boolean ignoreParseException) {
        this.ignoreParseException = ignoreParseException;
    }

    @Override
    public T populate(Class<T> clazz, String[] propertyNames, Object ... values) {
        Assert.notEmpty((Object[])values);
        Assert.notEmpty((Object[])propertyNames);
        Assert.isTrue((values.length == propertyNames.length ? 1 : 0) != 0, (String)("The length of propertyNames and values  must be same! " + propertyNames.length + " != " + values.length));
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(clazz);
            int i = 0;
            while (i < values.length) {
                Object value = null;
                String propertyName = propertyNames[i];
                Class propertyType = beanWrapper.getPropertyType(propertyName);
                if (propertyType != null) {
                    value = this.convertPropertyValue(values[i], propertyType);
                    beanWrapper.setPropertyValue(propertyName, value);
                } else if (StringUtils.contains((String)propertyName, (char)'.')) {
                    String[] names = StringUtils.split((String)propertyName, (char)'.');
                    StringBuilder prop = new StringBuilder(names[0]);
                    int j = 0;
                    while (j < names.length) {
                        String parentName;
                        Class parentType;
                        if (j > 0) {
                            prop.append('.');
                            prop.append(names[j]);
                        }
                        if ((parentType = beanWrapper.getPropertyType(parentName = prop.toString())) == null) break;
                        this.populateParent((BeanWrapper)beanWrapper, parentType, parentName);
                        ++j;
                    }
                    if ((propertyType = beanWrapper.getPropertyType(propertyName)) != null) {
                        value = this.convertPropertyValue(values[i], propertyType);
                        beanWrapper.setPropertyValue(propertyName, value);
                    }
                }
                ++i;
            }
            return (T)beanWrapper.getWrappedInstance();
        }
        catch (Exception e) {
            throw new PopulationFailedException(e);
        }
    }

    private void populateParent(BeanWrapper beanWrapper, Class<?> parentType, String parentName) {
        Object parent = beanWrapper.getPropertyValue(parentName);
        if (parent == null) {
            Object o = ReflectionUtils.newInstance(parentType);
            beanWrapper.setPropertyValue(parentName, o);
        }
    }

    private Object convertPropertyValue(Object value, Class<?> propertyType) {
        Object result = null;
        if (Date.class.isAssignableFrom(propertyType) && value != null) {
            Date d = this.parseDate(value.toString());
            result = DateConvertUtils.convertDateValue(d, propertyType);
        } else {
            result = value;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Date parseDate(String value) throws IllegalArgumentException {
        date /* !! */  = null;
        if (this.dateFormat != null) {
            format = new SimpleDateFormat(this.dateFormat);
            try {
                date /* !! */  = format.parse(value);
                return date /* !! */ ;
            }
            catch (ParseException var4_6) {
                // empty catch block
            }
        }
        try {
            date /* !! */  = Timestamp.valueOf(value);
            return date /* !! */ ;
        }
        catch (IllegalArgumentException format) {
            ** for (fmt : DefaultPopulator.defaultDateFormatList)
        }
lbl-1000:
        // 1 sources

        {
            format = new SimpleDateFormat(fmt);
            try {
                date /* !! */  = format.parse(value);
            }
            catch (ParseException var6_9) {
                // empty catch block
            }
            continue;
        }
lbl21:
        // 1 sources

        if (date /* !! */  == null && !this.ignoreParseException) {
            throw new IllegalArgumentException("Cannot parse " + value + ". Please set dateFormat.");
        }
        return date /* !! */ ;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

