/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.connector.InteractionHandler;
import com.mockrunner.mock.connector.cci.ConnectorMockObjectFactory;
import com.mockrunner.mock.connector.cci.MockInteraction;
import com.mockrunner.mock.connector.cci.MockLocalTransaction;
import com.mockrunner.mock.connector.cci.MockRecordFactory;
import java.util.List;
import javax.resource.cci.RecordFactory;

public class ConnectorTestModule {
    private ConnectorMockObjectFactory mockFactory;

    public ConnectorTestModule(ConnectorMockObjectFactory connectorMockObjectFactory) {
        this.mockFactory = connectorMockObjectFactory;
    }

    public InteractionHandler getInteractionHandler() {
        return this.mockFactory.getInteractionHandler();
    }

    private MockRecordFactory getMockRecordFactory() {
        try {
            RecordFactory recordFactory = this.mockFactory.getMockConnectionFactory().getRecordFactory();
            if (recordFactory instanceof MockRecordFactory) {
                return (MockRecordFactory)recordFactory;
            }
            return null;
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public List getInteractionList() {
        return this.mockFactory.getMockConnection().getInteractionList();
    }

    public List getCreatedIndexedRecords() {
        return this.getMockRecordFactory().getCreatedIndexedRecords();
    }

    public List getCreatedIndexedRecords(String string) {
        return this.getMockRecordFactory().getCreatedIndexedRecords(string);
    }

    public List getCreatedMappedRecords() {
        return this.getMockRecordFactory().getCreatedMappedRecords();
    }

    public List getCreatedMappedRecords(String string) {
        return this.getMockRecordFactory().getCreatedMappedRecords(string);
    }

    public void verifyConnectionClosed() {
        if (!this.mockFactory.getMockConnection().isClosed()) {
            throw new VerifyFailedException("Connection is not closed.");
        }
    }

    public void verifyAllInteractionsClosed() {
        List list = this.getInteractionList();
        for (int i = 0; i < list.size(); ++i) {
            MockInteraction mockInteraction = (MockInteraction)list.get(i);
            if (mockInteraction.isClosed()) continue;
            throw new VerifyFailedException("Interaction with index " + i + " is not closed.");
        }
    }

    public void verifyInteractionClosed(int n) {
        List list = this.getInteractionList();
        if (n >= list.size()) {
            throw new VerifyFailedException("Interaction with index " + n + " does not exist, only " + list.size() + " interactions.");
        }
        MockInteraction mockInteraction = (MockInteraction)list.get(n);
        if (!mockInteraction.isClosed()) {
            throw new VerifyFailedException("Interaction with index " + n + " is not closed.");
        }
    }

    public void verifyNumberCreatedIndexedRecords(int n) {
        int n2 = this.getMockRecordFactory().getNumberCreatedIndexedRecords();
        if (n2 != n) {
            throw new VerifyFailedException("Expected " + n + " indexed records, actual " + n2 + " indexed records");
        }
    }

    public void verifyNumberCreatedIndexedRecords(String string, int n) {
        List list = this.getCreatedIndexedRecords(string);
        if (list.size() != n) {
            throw new VerifyFailedException("Expected " + n + " indexed records with the name " + string + ", actual " + list.size() + " indexed records");
        }
    }

    public void verifyNumberCreatedMappedRecords(int n) {
        int n2 = this.getMockRecordFactory().getNumberCreatedMappedRecords();
        if (n2 != n) {
            throw new VerifyFailedException("Expected " + n + " mapped records, actual " + n2 + " mapped records");
        }
    }

    public void verifyNumberCreatedMappedRecords(String string, int n) {
        List list = this.getCreatedMappedRecords(string);
        if (list.size() != n) {
            throw new VerifyFailedException("Expected " + n + " mapped records with the name " + string + ", actual " + list.size() + " mapped records");
        }
    }

    public void verifyLocalTransactionCommitted() {
        MockLocalTransaction mockLocalTransaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (!mockLocalTransaction.wasCommitCalled()) {
            throw new VerifyFailedException("Local transaction not committed");
        }
    }

    public void verifyLocalTransactionNotCommitted() {
        MockLocalTransaction mockLocalTransaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (mockLocalTransaction.wasCommitCalled()) {
            throw new VerifyFailedException("Local transaction was committed");
        }
    }

    public void verifyLocalTransactionRolledBack() {
        MockLocalTransaction mockLocalTransaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (!mockLocalTransaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Local transaction not rolled back");
        }
    }

    public void verifyLocalTransactionNotRolledBack() {
        MockLocalTransaction mockLocalTransaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (mockLocalTransaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Local transaction was rolled back");
        }
    }
}

