/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;

public class MockJspWriter
extends JspWriter {
    private PrintWriter printWriter;
    private Writer writer;
    private boolean providedWriter;

    public MockJspWriter() {
        super(0, true);
        this.writer = new StringWriter();
        this.initWriter();
        this.providedWriter = false;
    }

    public MockJspWriter(Writer writer) {
        super(0, true);
        this.writer = writer;
        this.initWriter();
        this.providedWriter = true;
    }

    public String getOutputAsString() {
        try {
            this.flush();
            if (!this.providedWriter) {
                return ((StringWriter)this.writer).toString();
            }
            return "";
        }
        catch (IOException iOException) {
            throw new NestedApplicationException(iOException);
        }
    }

    public String toString() {
        return this.getOutputAsString();
    }

    public void clear() throws IOException {
        if (this.providedWriter) {
            throw new IOException("Illegal call if writer is provided.");
        }
        this.writer = new StringWriter();
        this.initWriter();
    }

    public void clearBuffer() throws IOException {
        if (!this.providedWriter) {
            this.writer = new StringWriter();
            this.initWriter();
        }
    }

    public void close() throws IOException {
        this.flush();
        this.printWriter.close();
    }

    public int getRemaining() {
        return 0;
    }

    public void flush() throws IOException {
        this.printWriter.flush();
    }

    public void newLine() throws IOException {
        this.print(System.getProperty("line.separator"));
    }

    public void print(boolean bl) throws IOException {
        this.printWriter.print(bl);
    }

    public void print(char c) throws IOException {
        this.printWriter.print(c);
    }

    public void print(char[] cArray) throws IOException {
        this.printWriter.print(cArray);
    }

    public void print(double d) throws IOException {
        this.printWriter.print(d);
    }

    public void print(float f) throws IOException {
        this.printWriter.print(f);
    }

    public void print(int n) throws IOException {
        this.printWriter.print(n);
    }

    public void print(long l) throws IOException {
        this.printWriter.print(l);
    }

    public void print(Object object) throws IOException {
        this.printWriter.print(object);
    }

    public void print(String string) throws IOException {
        this.printWriter.print(string);
    }

    public void println() throws IOException {
        this.printWriter.println();
    }

    public void println(boolean bl) throws IOException {
        this.printWriter.println(bl);
    }

    public void println(char c) throws IOException {
        this.printWriter.println(c);
    }

    public void println(char[] cArray) throws IOException {
        this.printWriter.println(cArray);
    }

    public void println(double d) throws IOException {
        this.printWriter.println(d);
    }

    public void println(float f) throws IOException {
        this.printWriter.println(f);
    }

    public void println(int n) throws IOException {
        this.printWriter.println(n);
    }

    public void println(long l) throws IOException {
        this.printWriter.println(l);
    }

    public void println(Object object) throws IOException {
        this.printWriter.println(object);
    }

    public void println(String string) throws IOException {
        this.printWriter.println(string);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.printWriter.write(cArray, n, n2);
    }

    private void initWriter() {
        this.printWriter = new PrintWriter(this.writer);
    }
}

