/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * {@link UpdateDAO}̃bNłB
 * 
 */
public class MockUpdateDao extends AbstractMockDao implements UpdateDAO {

    public void addBatch(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        pollAndExecuteIfCallback(new Object[] { sqlId, bindParams });
    }

    public int execute(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollInt();
    }

    @Deprecated
    public int executeBatch() {
        addParam(new DaoParam(null, null));
        return pollInt();
    }

    public int executeBatch(List<SqlHolder> sqlHolders) {
        for (SqlHolder sqlHolder : sqlHolders) {
            addParam(new DaoParam(sqlHolder.getSqlID(),
                    sqlHolder.getBindParams()));
        }
        return pollInt();
    }

}
