/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.testcase;

import static jp.terasoluna.fw.ex.unit.common.PropertyKeys.WEBAPP_PATH;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;
import jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils;

import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.util.Assert;

/**
 * DAOsxeXgP[XB
 * 
 * <pre>
 * {ł͑OSpring{@link org.springframework.context.ApplicationContext}쐬܂B
 * 쐬ɂ͎̐ݒt@Cǂݍ݂܂B
 * </pre>
 * <table border=1>
 * <tr>
 * <th>ݒt@C</th>
 * <th>ftHgl</th>
 * <th>ύX|Cg</th>
 * <th>l</th>
 * </tr>
 * <tr>
 * <td>Bean`t@C</td>
 * <td>WEB-INF/applicationContext.xml</td>
 * <td>terasoluna-unit-override.properties̈ȉɃL[ɑ΂lݒ肷邱ƂŁAύX\łB<br>
 * WEB-INF -&gt; webinf.dir<br>
 * applicationContext.xml -&gt; applicationcontext.file<br>
 * </td>
 * <td>t@C݂ȂꍇA܂BRXgN^ɂ{@link #setLoadDefaultConfig(boolean)}
 * falseݒ肵ꍇ܂{@link #isLoadDefaultConfig()}falseԂ悤ɃI[oChꍇAǂݍ݂܂B
 * </td>
 * </tr>
 * <tr>
 * <td>W[Bean`t@C</td>
 * <td>WEB-INF/moduleContext.xml</td>
 * <td>terasoluna-unit-override.properties̈ȉɃL[ɑ΂lݒ肷邱ƂŁAύX\łB<br>
 * WEB-INF -&gt; webinf.dir<br>
 * moduleContext.xml -&gt; modulecontext.file<br>
 * </td>
 * <td>t@C݂ȂꍇA܂BRXgN^ɂ{@link #setLoadDefaultConfig(boolean)}
 * falseݒ肵ꍇ܂{@link #isLoadDefaultConfig()}falseԂ悤ɃI[oChꍇAǂݍ݂܂B
 * </td>
 * </tr>
 * <tr>
 * <td>Bean`t@C</td>
 * <td>Ȃ</td>
 * <td>
 * {@link #addConfigLocations(List)}
 * \bhI[o[ChāABean`t@CpXXgɒǉt@C̃pXaddĂB</td>
 * <td>t@C݂ȂꍇA
 * {@link org.springframework.beans.factory.BeanDefinitionStoreException}
 * X[܂B</td>
 * </tr>
 * </table>
 * 
 * <pre>
 * Bean`t@Cɂ{@link java.sql.DataSource}̒`KvłADBڑsƂł܂B
 * (ADBpӂKv܂B)
 * 
 * 
 * ǂݍBean`t@Cɒ`BeanR[hŎgpꍇAȉ̓ނBean擾@܂B
 * 
 * 1. {@link org.springframework.context.ApplicationContext#getBean(String)}ɂĎ擾@
 * 2. setter`autowire(by type)@
 * 
 * ȉ̂悤Ȓ`ꍇɂƂĐ܂B
 * 
 * WEB-INF/foo/fooContext.xml
 * 
 * &lt;!-- O㗪 --&gt;
 * &lt;bean id=&quot;foo&quot; class=&quot;com.example.Foo&quot; /&gt;
 * &lt;bean name=&quot;/foo&quot; class=&quot;com.example.FooBLogic&quot; /&gt;
 * 
 * 1. {@link org.springframework.context.ApplicationContext#getBean(String)}ɂĎ擾@
 * 
 * public FooTest extends {@link DaoTestCase} {
 *   public void testDoSomething() throws Exception {
 *     Foo foo = getBean(&quot;foo&quot;);
 *     // 邢 Foo foo = (Foo) applicationContext.getBean(&quot;foo&quot;);
 *     int result = foo.doSomething();
 *     assertEquals(1, result);
 *   }
 * }
 * 
 * public FooBLogicTest extends {@link DaoTestCase} {
 *   public void testFoo()  throws Exception {
 *     FooBLogic foo = getBean(&quot;/foo&quot;);
 *     // 邢 FooBLogic foo = (FooBLogic) applicationContext.getBean(&quot;/foo&quot;);
 *     BLogicResult result = foo.execute(null);
 *     {@link AssertUtils}.assertBLogicSuccess(result);
 *   }
 * }
 * 
 * 擾BeañC^[tFCXAOPݒ肵Ăꍇ́Aϐ̌^AOPΏۂ̃C^[tFCXɂKv܂B
 * 
 * 2. setter`autowire(by type)@
 * 擾BeañZb^[`ĂB
 * 
 * public FooTest extends {@link DaoTestCase} {
 *   private Foo foo;
 *   
 *   public void setFoo(Foo foo) {
 *     this.foo = foo;
 *   }
 *  
 *   public void testDoSomething()  throws Exception {
 *     int result = foo.doSomething();
 *     assertEquals(1, result);
 *   }
 * }
 * 
 * public FooBLogicTest extends {@link DaoTestCase} {
 *   private FooBLogic foo;
 *   
 *   public void setFoo(FooBLogic foo) {
 *     this.foo = foo;
 *   }
 *   
 *   public void testFoo() throws Exception {
 *     BLogicResult result = foo.execute(null);
 *     {@link AssertUtils}.assertBLogicSuccess(result);
 *   }
 * }
 * 
 * &lt;strong&gt;̕@͈ȉ̏ꍇɂ͗pł܂B&lt;/strong&gt;
 * EBean`t@Cɓ^Bean`Ăꍇ
 * EAOPɂ{@link ApplicationContext}{@link java.lang.reflect.Proxy}NXƂĎ擾ꍇ
 * 
 * {NXpeXg͈ȉ̗lɏs
 * 
 * - O
 * -- WEBAPfBNg(ReLXg[g)̃NXpXւ̒ǉ({@link TestCaseUtils#getConfigLocationsForDaoTestCase(String[])})
 * -- Bean`t@CǂݍݑO({@link #beforeGetConfig()}Ŏ)
 * -- ǂݍBean`t@Cǉ({@link #addConfigLocations(List)}Ŏ)
 * -- {@link ApplicationContext}쐬
 * -- gUNVJnOO({@link #onSetUpBeforeTransaction()}Ŏ)
 * -- gUNVJnO({@link #onSetUpInTransaction()}Ŏ)
 * 
 * - s
 * 
 * - ㏈
 * -- gUNVIO㏈({@link #onTearDownInTransaction()})Ŏ
 * -- gUNVI㏈({@link #onTearDownAfterTransaction()}Ŏ)
 * 
 * </pre>
 */
public abstract class DaoTestCase extends
        AbstractTransactionalDataSourceSpringContextTests {
    /**
     * ftHgBean`t@Cǂݍނǂ
     */
    private boolean loadDefaultConfig = true;

    public DaoTestCase() {
        super();
    }

    public DaoTestCase(String name) {
        super(name);
    }

    @Override
    protected final String getConfigPath() {
        // WEBAPfBNgNXpXɒǉ܂
        String contextRoot = DefaultProperties.getValue(WEBAPP_PATH);
        if (logger.isInfoEnabled()) {
            logger.info("add " + contextRoot + " to classpath");
        }
        ClassLoaderUtils.addClassPath(contextRoot);
        beforeGetConfig();
        return super.getConfigPath();
    }

    /**
     * Bean擾܂B
     * 
     * @param <T>
     *            擾Beaň^
     * @param name
     *            beanid܂name
     * @return 擾Bean
     */
    @SuppressWarnings("unchecked")
    public <T> T getBean(String name) {
        Assert.notNull(applicationContext, "applicationContext is null!");
        return (T) applicationContext.getBean(name);
    }

    /**
     * Bean`t@CpX擾OB
     * 
     * <pre>
     * DIRei쐬OɎs͂̃\bhI[oChĎsĂB
     * FJNDIANeBx[g铙
     * </pre>
     */
    protected void beforeGetConfig() {
        // ftHgł͉܂
    }

    /**
     * ǂݍBean`t@CpXǉ܂B
     * 
     * <pre>
     * Bean`t@CpXXgɒǉt@C̃pXadd悤I[o[ChĂB
     * </pre>
     * 
     * @param configLocations
     *            ǂݍBean`t@CXg
     */
    protected void addConfigLocations(List<String> configLocations) {
    }

    @Override
    protected void onTearDown() throws Exception {
        super.onTearDown();
        ClassLoaderUtils.resetClassLoader();
    }

    @Override
    protected final String[] getConfigLocations() {
        List<String> configLocations = null;
        if (isLoadDefaultConfig()) {
            // ftHgBean`t@Cǉ܂
            configLocations = TestCaseUtils
                    .getConfigLocationsForDaoTestCase(super
                            .getConfigLocations());
        } else {
            configLocations = new ArrayList<String>();
        }

        // qNXŒǉꍇ
        addConfigLocations(configLocations);

        String[] configs = configLocations.toArray(new String[configLocations
                .size()]);

        if (logger.isInfoEnabled()) {
            logger.info("load configLocations = " + configLocations);
        }

        return configs;
    }

    /**
     * ftHgBean`t@Cǂݍނǂݒ肵܂
     * 
     * @param loadDefaultConfig
     *            ftHgBean`t@Cǂݍނǂ
     */
    public void setLoadDefaultConfig(boolean loadDefaultConfig) {
        this.loadDefaultConfig = loadDefaultConfig;
    }

    /**
     * ftHgBean`t@Cǂݍނǂ擾܂
     * 
     * @return ftHgBean`t@Cǂݍނǂ
     */
    public boolean isLoadDefaultConfig() {
        return loadDefaultConfig;
    }

    protected void deleteFromTable(String name) {
        super.deleteFromTables(new String[] { name });
    }

    // ȉJdbcTemplateUtils̃bp[

    /**
     * @param sql
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#execute(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public void execute(String sql) throws DataAccessException {
        JdbcTemplateUtils.execute(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#update(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public int update(String sql) throws DataAccessException {
        return JdbcTemplateUtils.update(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#update(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public int update(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.update(jdbcTemplate, sql, args);
    }

    /**
     * @param sqls
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#batchUpdate(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String[])
     */
    public int[] batchUpdate(String... sqls) throws DataAccessException {
        return JdbcTemplateUtils.batchUpdate(jdbcTemplate, sqls);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForLong(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public long queryForLong(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForLong(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForLong(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public long queryForLong(String sql, Object[] args)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForLong(jdbcTemplate, sql, args);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForInt(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public int queryForInt(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForInt(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForInt(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public int queryForInt(String sql, Object[] args)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForInt(jdbcTemplate, sql, args);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForString(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public String queryForString(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForString(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForString(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public String queryForString(String sql, Object[] args)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForString(jdbcTemplate, sql, args);
    }

    /**
     * @param <T>
     * @param sql
     * @param requiredType
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForObject(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Class)
     */
    public <T> T queryForObject(String sql, Class<T> requiredType)
            throws DataAccessException {
        return JdbcTemplateUtils
                .queryForObject(jdbcTemplate, sql, requiredType);
    }

    /**
     * @param <T>
     * @param sql
     * @param args
     * @param requiredType
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForObject(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[], java.lang.Class)
     */
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForObject(jdbcTemplate, sql, args,
                requiredType);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowMap(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public Map<String, ?> queryForRowMap(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMap(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowMap(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public Map<String, ?> queryForRowMap(String sql, Object[] args)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMap(jdbcTemplate, sql, args);
    }

    /**
     * @param <T>
     * @param sql
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowObject(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Class)
     */
    public <T> T queryForRowObject(String sql, Class<T> clazz)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObject(jdbcTemplate, sql, clazz);
    }

    /**
     * @param <T>
     * @param sql
     * @param args
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowObject(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[], java.lang.Class)
     */
    public <T> T queryForRowObject(String sql, Object[] args, Class<T> clazz)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObject(jdbcTemplate, sql, args,
                clazz);
    }

    /**
     * @param <T>
     * @param sql
     * @param elementType
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForSingleColumnList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Class)
     */
    public <T> List<T> queryForSingleColumnList(String sql, Class<T> elementType)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForSingleColumnList(jdbcTemplate, sql,
                elementType);
    }

    /**
     * @param <T>
     * @param sql
     * @param args
     * @param elementType
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForSingleColumnList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[], java.lang.Class)
     */
    public <T> List<T> queryForSingleColumnList(String sql, Object[] args,
            Class<T> elementType) throws DataAccessException {
        return JdbcTemplateUtils.queryForSingleColumnList(jdbcTemplate, sql,
                args, elementType);
    }

    /**
     * @param sql
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowMapList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String)
     */
    public List<Map<String, ?>> queryForRowMapList(String sql)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(jdbcTemplate, sql);
    }

    /**
     * @param sql
     * @param args
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowMapList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[])
     */
    public List<Map<String, ?>> queryForRowMapList(String sql, Object[] args)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(jdbcTemplate, sql, args);
    }

    /**
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowMapList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.Class)
     */
    public List<Map<String, ?>> queryForRowMapList(Class<?> clazz)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(jdbcTemplate, clazz);
    }

    /**
     * @param <T>
     * @param sql
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowObjectList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Class)
     */
    public <T> List<T> queryForRowObjectList(String sql, Class<T> clazz)
            throws DataAccessException {
        return JdbcTemplateUtils
                .queryForRowObjectList(jdbcTemplate, sql, clazz);
    }

    /**
     * @param <T>
     * @param sql
     * @param args
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowObjectList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.String, java.lang.Object[], java.lang.Class)
     */
    public <T> List<T> queryForRowObjectList(String sql, Object[] args,
            Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObjectList(jdbcTemplate, sql, args,
                clazz);
    }

    /**
     * @param <T>
     * @param clazz
     * @return
     * @throws DataAccessException
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#queryForRowObjectList(org.springframework.jdbc.core.JdbcTemplate,
     *      java.lang.Class)
     */
    public <T> List<T> queryForRowObjectList(Class<T> clazz)
            throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObjectList(jdbcTemplate, clazz);
    }

    /**
     * @param tableName
     * @param fieldNames
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createSelectSql(java.lang.String,
     *      java.lang.String[])
     */
    public String createSelectSql(String tableName, String[] fieldNames) {
        return JdbcTemplateUtils.createSelectSql(tableName, fieldNames);
    }

    /**
     * @param tableName
     * @param clazz
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createSelectSql(java.lang.String,
     *      java.lang.Class)
     */
    public String createSelectSql(String tableName, Class<?> clazz) {
        return JdbcTemplateUtils.createSelectSql(tableName, clazz);
    }

    /**
     * @param clazz
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createSelectSql(java.lang.Class)
     */
    public String createSelectSql(Class<?> clazz) {
        return JdbcTemplateUtils.createSelectSql(clazz);
    }

    /**
     * @param tableName
     * @param fieldNames
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createInsertSql(java.lang.String,
     *      java.lang.String[])
     */
    public String createInsertSql(String tableName, String[] fieldNames) {
        return JdbcTemplateUtils.createInsertSql(tableName, fieldNames);
    }

    /**
     * @param tableName
     * @param clazz
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createInsertSql(java.lang.String,
     *      java.lang.Class)
     */
    public String createInsertSql(String tableName, Class<?> clazz) {
        return JdbcTemplateUtils.createInsertSql(tableName, clazz);
    }

    /**
     * @param clazz
     * @return
     * @see jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils#createInsertSql(java.lang.Class)
     */
    public String createInsertSql(Class<?> clazz) {
        return JdbcTemplateUtils.createInsertSql(clazz);
    }

}
